/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.jpa.entitymanager;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jp.ecuacion.lib.jpa.dbaccess.DbAccessManager;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapper;
import jp.ecuacion.lib.jpa.dbaccess.EntityManagerWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
@Scope(value="prototype")
public class DbAccessManagerWithSpringJpa
extends DbAccessManager {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EntityManagerFactory emf;
    private JpaTransactionManager tm;
    private TransactionStatus status;

    protected EntityManager getOriginalEntityManager() {
        return this.entityManager;
    }

    public EntityManagerWrapper getEntityManager() {
        return new EntityManagerWrapperImpl(this.entityManager);
    }

    public JpaTransactionManager getTransactionManager() {
        return this.tm;
    }

    protected EntityManagerWrapper innerInitTransaction(EntityManagerWrapper entityManager) {
        this.tm = new JpaTransactionManager(this.emf);
        DefaultTransactionDefinition td = new DefaultTransactionDefinition();
        td.setName("transaction");
        td.setPropagationBehavior(0);
        this.status = this.tm.getTransaction((TransactionDefinition)td);
        return entityManager;
    }

    public void commitTransaction(EntityManagerWrapper entityManager) {
        this.tm.commit(this.status);
    }

    public void rollbackTransaction(EntityManagerWrapper entityManager) {
        this.tm.rollback(this.status);
    }
}

