/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.jpa.util;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.hibernate.Filter;
import org.hibernate.Session;

public abstract class SplibJpaFilterUtil {
    @PersistenceContext
    EntityManager em;
    private boolean usesSoftDeleteFeature;
    private boolean usesGroupFeature;
    private String groupColumnName;
    private boolean hasCustomGroupColumn;
    private String customGroupName;
    private String customGroupColumnName;

    public SplibJpaFilterUtil(boolean usesSoftDeleteFeature, boolean usesGroupFeature, String groupColumnName, boolean hasCustomGroupColumn, String customGroupName, String customGroupColumnName) {
        this.usesSoftDeleteFeature = usesSoftDeleteFeature;
        this.usesGroupFeature = usesGroupFeature;
        this.groupColumnName = groupColumnName;
        this.hasCustomGroupColumn = hasCustomGroupColumn;
        this.customGroupName = customGroupName;
        this.customGroupColumnName = customGroupColumnName;
    }

    public void enableGroupFilter(Object groupId) {
        if (this.usesGroupFeature) {
            Session session = (Session)this.em.unwrap(Session.class);
            Filter filter = session.enableFilter("groupFilter");
            filter.setParameter(this.groupColumnName, groupId);
            if (this.hasCustomGroupColumn) {
                Filter filterAccGroup = session.enableFilter(this.customGroupName);
                filterAccGroup.setParameter(this.customGroupColumnName, groupId);
            }
        }
    }

    public void disableGroupFilter() {
        if (this.usesGroupFeature) {
            Session session = (Session)this.em.unwrap(Session.class);
            session.disableFilter("groupFilter");
            if (this.hasCustomGroupColumn) {
                session.disableFilter(this.customGroupName);
            }
        }
    }

    public void enableSoftDeleteFilter() {
        if (this.usesSoftDeleteFeature) {
            Session session = (Session)this.em.unwrap(Session.class);
            session.enableFilter("softDeleteFilter");
        }
    }

    public void disableSoftDeleteFilter() {
        if (this.usesSoftDeleteFeature) {
            Session session = (Session)this.em.unwrap(Session.class);
            session.disableFilter("softDeleteFilter");
        }
    }
}

