package jp.ecuacion.splib.core.form.record;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jp.ecuacion.lib.core.form.record.AbstractRecord;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;

public abstract class SplibRecord extends AbstractRecord {

  private StringUtil strUtil = new StringUtil();

  protected DatetimeFormatParameters dateTimeFormatParams;

  protected static Map<String, Integer> stringLengthMap = new HashMap<>();

  public SplibRecord() {
    // defaultを使用
    dateTimeFormatParams = new DatetimeFormatParameters();
  }

  public SplibRecord(DatetimeFormatParameters params) {
    this.dateTimeFormatParams = params;
  }

  public Object getValue(String itemName) {
    Object rtn = null;

    try {
      if (itemName.contains(".")) {
        String recordName = itemName.substring(0, itemName.indexOf("."));
        String fieldName = itemName.substring(itemName.indexOf(".") + 1);

        Method m = this.getClass().getMethod("get" + strUtil.capitalize(recordName));

        // そもそもrelationのrecordの値がnullの場合は、それにgetValueするとNullPointerになるのでその前に返す
        SplibRecord relationRec = (SplibRecord) m.invoke(this);
        if (relationRec == null) {
          return null;
        }

        rtn = (relationRec).getValue(fieldName);

      } else {
        Method m = this.getClass().getMethod("get" + strUtil.capitalize(itemName));
        // Stringの場合とSplibJpaRecordの場合があるが、Objectで返すだけなので条件分岐は不要。
        rtn = m.invoke(this);
      }

    } catch (Exception e) {
      throw new RuntimeException(e);
    }

    return rtn;
  }

  public DatetimeFormatParameters getDateTimeFormatParams() {
    return dateTimeFormatParams;
  }

  public void setDateTimeFormatParams(DatetimeFormatParameters dateTimeFormatParams) {
    this.dateTimeFormatParams = dateTimeFormatParams;
  }

  public Integer getStringLength(String itemName) {
    return stringLengthMap.get(itemName);
  }
}
