package jp.ecuacion.splib.core.container;

import java.time.ZoneOffset;

public class DatetimeFormatParameters {

  private ZoneOffset zoneOffset;

  /** 現在dateTimeという型はlibrary上ないが、本来timestampとは異なる意味合いのはずなので念のため保持しておく。 */
  private String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
  //yyyy-MM-dd HH:mm:ss.SSSSSS XXX
  private String timestampFormat = "yyyy-MM-dd HH:mm:ss.SSSSSS XXX"; 
  private String dateFormat = "yyyy-MM-dd";
  private String timeFormat = "yyyy-MM-dd";

  public DatetimeFormatParameters() {

  }

  public DatetimeFormatParameters(ZoneOffset zoneOffset) {
    this.zoneOffset = zoneOffset;
  }

  public ZoneOffset getZoneOffset() {
    return zoneOffset;
  }

  public void setZoneOffset(ZoneOffset zoneOffset) {
    this.zoneOffset = zoneOffset;
  }

  /**
   * javascriptのDateオブジェクトのgetTimezoneOffset() メソッドにて取得される値を引数に渡す形でのoffset指定。 UTC+0900（日本）だと -9(時間)
   * × 60(分) = -540 という値。 これを「ZoneOffset.ofHours(9)」の形で保持。
   */
  public void setZoneOffsetWithJsMinutes(int minutes) {
    int hour = -1 * minutes / 60;
    int minute = -1 * minutes % 60;

    zoneOffset = ZoneOffset.ofHoursMinutes(hour, minute);
  }

  public String getDateTimeFormat() {
    return dateTimeFormat;
  }

  public void setDateTimeFormat(String dateTimeFormat) {
    this.dateTimeFormat = dateTimeFormat;
  }

  public String getTimestampFormat() {
    return timestampFormat;
  }

  public void setTimestampFormat(String timestampFormat) {
    this.timestampFormat = timestampFormat;
  }

  public String getDateFormat() {
    return dateFormat;
  }

  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public String getTimeFormat() {
    return timeFormat;
  }

  public void setTimeFormat(String timeFormat) {
    this.timeFormat = timeFormat;
  }
}
