package jp.ecuacion.splib.core.container;

import java.time.ZoneOffset;

public class DatetimeFormatParameters {
  
  private ZoneOffset zoneOffset;
  private String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
  
  public DatetimeFormatParameters() {
    
  }
  
  public DatetimeFormatParameters(ZoneOffset zoneOffset) {
    this.zoneOffset = zoneOffset;
  }
  
  public ZoneOffset getZoneOffset() {
    return zoneOffset;
  }
  
  public void setZoneOffset(ZoneOffset zoneOffset) {
    this.zoneOffset = zoneOffset;
  }
  
  /** 
   * javascriptのDateオブジェクトのgetTimezoneOffset() メソッドにて取得される値を引数に渡す形でのoffset指定。
   * UTC+0900（日本）だと -9(時間) × 60(分) = -540 という値。
   * これを「ZoneOffset.ofHours(9)」の形で保持。
   */
  public void setZoneOffsetWithJsMinutes(int minutes) {
    int hour = -1 * minutes / 60;
    int minute = -1 * minutes % 60;
    
    zoneOffset = ZoneOffset.ofHoursMinutes(hour, minute);
  }
  
  public String getDatetimeFormat() {
    return datetimeFormat;
  }
  
  public void setDatetimeFormat(String datetimeFormat) {
    this.datetimeFormat = datetimeFormat;
  }
}
