/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.batch.exceptionhandler;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.splib.batch.advice.SplibBatchAdvice;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplibExceptionHandler
implements ExceptionHandler {
    @Autowired(required=false)
    private SplibExceptionHandlerAction action;
    private LogUtil logUtil = new LogUtil((Object)this);
    private ExceptionUtil exUtil = new ExceptionUtil();
    private DetailLogger detailLog = new DetailLogger((Object)this);
    private static final String NOT_FOUND_MSG_TMPL = "(The classname of {0} is null because the error occured outside {0}or the advice to register current {0} is not implemented.)";

    public void handleException(RepeatContext context, @RequireNonnull Throwable throwable) throws Throwable {
        throwable = (Throwable)ObjectsUtil.paramRequireNonNull((Object)throwable);
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatMsg("job", SplibBatchAdvice.getCurrentJob(), true));
        sb.append(this.formatMsg("step", SplibBatchAdvice.getCurrentStep(), false));
        sb.append(this.formatMsg("tasklet or chunk", SplibBatchAdvice.getCurrentTaskletOrChunk(), false));
        this.logUtil.logError(throwable, sb.toString());
        if (this.action != null) {
            try {
                this.action.execute(throwable);
            }
            catch (Throwable th) {
                this.logUtil.logError(th);
            }
        }
        if (throwable instanceof AppException || throwable instanceof UncheckedAppException) {
            AppException appEx = null;
            appEx = throwable instanceof UncheckedAppException ? (AppException)((UncheckedAppException)throwable).getCause() : (AppException)throwable;
            List msgList = this.exUtil.getAppExceptionMessageList(appEx, Locale.getDefault());
            this.detailLog.info("==========");
            this.detailLog.info("[AppException \u30e1\u30c3\u30bb\u30fc\u30b8\u4e00\u89a7]");
            msgList.stream().forEach(msg -> this.detailLog.info(msg));
            this.detailLog.info("==========");
        }
        throw throwable;
    }

    private String formatMsg(String kind, String name, boolean is1st) {
        return (is1st ? "" : ", ") + (String)(name == null ? MessageFormat.format(NOT_FOUND_MSG_TMPL, "'" + kind + "'") : kind + ": " + name);
    }
}

