package jp.ecuacion.splib.batch.advice;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

@Aspect
@Component
public  class SplibBatchAdvice {

  private static ThreadLocal<String> currentJob = new ThreadLocal<>();

  private static ThreadLocal<String> currentStep = new ThreadLocal<>();

  /** tasklet / chunkを両方入れられるようObjedctで保持。 */
  private static ThreadLocal<String> currentTaskletOrChunk = new ThreadLocal<>();

  @Before("execution(* org.springframework.batch.core.step.tasklet.Tasklet.execute(..))")
  public void onBeforeTaskletExecute(JoinPoint joinPoint) {
    currentTaskletOrChunk.set(joinPoint.getThis().getClass().getSimpleName());
  }

  /** chunkでの実装方式が確定していないので確定後要実装。 */
  @Before("execution(* org.springframework.batch.item.Chunk.execute(..))")
  public void onBeforeChunkExecute(JoinPoint joinPoint) {
    currentTaskletOrChunk.set(joinPoint.getThis().getClass().getSimpleName());
  }

  public static String getCurrentJob() {
    return currentJob.get();
  }

  public static void setCurrentJob(String currentJob) {
    SplibBatchAdvice.currentJob.set(currentJob);
  }

  public static String getCurrentStep() {
    return currentStep.get();
  }

  public static void setCurrentStep(String currentStep) {
    SplibBatchAdvice.currentStep.set(currentStep);
  }

  public static String getCurrentTaskletOrChunk() {
    return currentTaskletOrChunk.get();
  }

  public static void setCurrentTasklet(String currentTaskletOrChunk) {
    SplibBatchAdvice.currentTaskletOrChunk.set(currentTaskletOrChunk);
  }
}
