package jp.ecuacion.splib.batch.config;

import jp.ecuacion.splib.batch.exceptionhandler.SplibExceptionHandler;
import jp.ecuacion.splib.batch.listener.SplibJobExecutionListener;
import jp.ecuacion.splib.batch.listener.SplibStepExecutionListener;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class SplibAppParentBatchConfig {

  @Autowired
  private SplibJobExecutionListener jobExecutionListener;
  @Autowired
  private SplibStepExecutionListener stepExecutionListener;
  @Autowired
  private SplibExceptionHandler exceptionHandler;

  protected JobBuilder preparedJobBuilder(String jobName, JobRepository jobRepository) {
    return new JobBuilder(jobName, jobRepository).incrementer(new RunIdIncrementer())
        .listener(jobExecutionListener);
  }

  /** chunkは実際に実装してみてからどう組み入れるかを決定予定。 */
  protected TaskletStepBuilder preparedStepBuilder(String stepName, JobRepository jobRepository,
      PlatformTransactionManager transactionManager, Tasklet... tasklets) {
    StepBuilder builder = new StepBuilder(stepName, jobRepository).listener(stepExecutionListener);
    TaskletStepBuilder tlBuilder = null;
    for (Tasklet tasklet : tasklets) {
      if (tlBuilder == null) {
        tlBuilder = buildTasklet(builder, tasklet, transactionManager);

      } else {
        tlBuilder = buildTasklet(tlBuilder, tasklet, transactionManager);
      }
    }

    return tlBuilder;
  }

  private TaskletStepBuilder buildTasklet(Object builder, Tasklet tasklet,
      PlatformTransactionManager transactionManager) {
    TaskletStepBuilder tlBuilder = builder instanceof StepBuilder
        ? ((StepBuilder) builder).tasklet(tasklet, transactionManager)
        : ((TaskletStepBuilder) builder).tasklet(tasklet, transactionManager);
    
    return tlBuilder.exceptionHandler(exceptionHandler);
  }
}
