package jp.ecuacion.splib.batch.exceptionhandler;

import java.text.MessageFormat;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.splib.batch.advice.SplibBatchAdvice;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplibExceptionHandler implements ExceptionHandler {

  @Autowired(required = false)
  private SplibExceptionHandlerAction action;

  private LogUtil logUtil = new LogUtil(this);

  private static final String NOT_FOUND_MSG_TMPL =
      "(The classname of {0} is null because the error occured outside {0}"
          + "or the advice to register current {0} is not implemented.)";

  @Override
  public void handleException(RepeatContext context, Throwable throwable) throws Throwable {

    StringBuilder sb = new StringBuilder();
    sb.append(formatMsg("job", SplibBatchAdvice.getCurrentJob(), true));
    sb.append(formatMsg("step", SplibBatchAdvice.getCurrentStep(), false));
    sb.append(formatMsg("tasklet or chunk", SplibBatchAdvice.getCurrentTaskletOrChunk(), false));

    logUtil.logErr(throwable, sb.toString());

    if (action != null) {
      try {
        action.execute(throwable);

      } catch (Throwable th) {
        logUtil.logErr(th);
      }
    }

    throw throwable;
  }

  private String formatMsg(String kind, String name, boolean is1st) {
    return (is1st ? "" : ", ")
        + (name == null ? MessageFormat.format(NOT_FOUND_MSG_TMPL, "'" + kind + "'")
            : kind + ": " + name);
  }
}
