package jp.ecuacion.splib.batch.exceptionhandler;

import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplibExceptionHandler implements ExceptionHandler {

  @Autowired(required = false)
  private SplibExceptionHandlerAction action;
  
  private LogUtil logUtil = new LogUtil(this);
  
  @Override
  public void handleException(RepeatContext context, Throwable throwable) throws Throwable {

    logUtil.logErr(throwable);
    
    if (action != null) {
      try {
        action.throwble(throwable);
      
      } catch (Throwable th) {
        logUtil.logErr(throwable);
      }
    }

    throw throwable;
  }
}
