package jp.ecuacion.splib.batch.exceptionhandler;

import java.util.Arrays;
import jp.ecuacion.lib.core.util.ExceptionHandlerUtil;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;

public class SplibExceptionHandler implements ExceptionHandler {

  @Override
  public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
    new ExceptionHandlerUtil().logAndMailError(
        throwable, Arrays.asList(new String[] {"yosuke.tanaka@ecuacion.jp"}));
    throw throwable;
  }

}
