package jp.ecuacion.splib.batch.listener;

import jp.ecuacion.splib.batch.advice.SplibBatchAdvice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.stereotype.Component;

@Component
public class SplibJobExecutionListener implements JobExecutionListener {

  protected static final Logger logger = LoggerFactory.getLogger("summary-logger");

  @Override
  public void beforeJob(JobExecution jobExecution) {
    logger.info("START: job-name: " + jobExecution.getJobInstance().getJobName());
    SplibBatchAdvice.setCurrentJob(jobExecution.getJobInstance().getJobName());
  }

  @Override
  public void afterJob(JobExecution jobExecution) {
    if (jobExecution.getStatus().isUnsuccessful()) {
      logger.error("END  : job-name: " + jobExecution.getJobInstance().getJobName()
          + " [ABNORMAL END] exit status: " + jobExecution.getExitStatus().getExitCode());
      // jobExecution.getAllFailureExceptions().forEach(Throwable::printStackTrace);

    } else {
      // バッチが正常に終了した場合
      logger
          .info("END  : job-name: " + jobExecution.getJobInstance().getJobName() + " [NORMAL END]");
    }
  }
}
