package jp.ecuacion.splib.batch.exceptionhandler;

import java.text.MessageFormat;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.splib.batch.advice.SplibBatchAdvice;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplibExceptionHandler implements ExceptionHandler {

  @Autowired(required = false)
  private SplibExceptionHandlerAction action;

  private LogUtil logUtil = new LogUtil(this);

  private static final String NOT_FOUND_MSG_TMPL =
      "(The classname of {0} is null because the error occured outside {0}"
          + "or the advice to register current {0} is not implemented.)";

  @Override
  public void handleException(RepeatContext context, Throwable throwable) throws Throwable {

    StringBuilder sb = new StringBuilder();
    sb.append(buildAdditionalMessageString(SplibBatchAdvice.getCurrentJob(), "job"));
    sb.append(buildAdditionalMessageString(SplibBatchAdvice.getCurrentStep(), "step"));
    sb.append(buildAdditionalMessageString(SplibBatchAdvice.getCurrentTaskletOrChunk(),
        "tasklet or chunk"));

    logUtil.logErr(throwable, sb.toString());

    if (action != null) {
      try {
        action.execute(throwable);

      } catch (Throwable th) {
        logUtil.logErr(th);
      }
    }

    context.setTerminateOnly();
  }

  private String buildAdditionalMessageString(String name, String kind) {
    return (name == null ? MessageFormat.format(NOT_FOUND_MSG_TMPL, "'" + kind + "'")
        : kind + ": " + name) + "\n";
  }
}
