package jp.ecuacion.splib.batch.config;

import jp.ecuacion.splib.batch.listener.SplibJobExecutionListener;
import jp.ecuacion.splib.batch.listener.SplibStepExecutionListener;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SplibAppParentBatchConfig {

  @Autowired
  private SplibJobExecutionListener jobExecutionListener;
  @Autowired
  private SplibStepExecutionListener stepExecutionListener;

  protected JobBuilder preparedJobBuilder(String jobName, JobRepository jobRepository) {
    return new JobBuilder(jobName, jobRepository).incrementer(new RunIdIncrementer())
        .listener(jobExecutionListener);
  }

  protected StepBuilder preparedStepBuilder(String stepName, JobRepository jobRepository) {
    return new StepBuilder(stepName, jobRepository).listener(stepExecutionListener);

  }
}
