/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.batch.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.stereotype.Component;

@Component
public class SplibJobExecutionListener
implements JobExecutionListener {
    protected static final Logger logger = LoggerFactory.getLogger((String)"summary-logger");

    public void beforeJob(JobExecution jobExecution) {
        logger.info("START: job-name: " + jobExecution.getJobInstance().getJobName());
    }

    public void afterJob(JobExecution jobExecution) {
        if (jobExecution.getStatus().isUnsuccessful()) {
            logger.error("END  : job-name: " + jobExecution.getJobInstance().getJobName() + " [ABNORMAL END] exit status: " + jobExecution.getExitStatus().getExitCode());
        } else {
            logger.info("END  : job-name: " + jobExecution.getJobInstance().getJobName() + " [NORMAL END]");
        }
    }
}

