/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.batch.exceptionhandler;

import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplibExceptionHandler
implements ExceptionHandler {
    @Autowired(required=false)
    private SplibExceptionHandlerAction action;
    private LogUtil logUtil = new LogUtil((Object)this);

    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        this.logUtil.logErr(throwable);
        if (this.action != null) {
            try {
                this.action.execute(throwable);
            }
            catch (Throwable th) {
                this.logUtil.logErr(throwable);
            }
        }
        context.setTerminateOnly();
    }
}

