package jp.ecuacion.splib.batch.config;

import jp.ecuacion.splib.batch.listener.SplibJobExecutionListener;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SplibAppParentBatchConfig {

  @Autowired
  private SplibJobExecutionListener jobExecutionListener;
  
  protected JobBuilder preparedJobBuilder(String jobName, JobRepository jobRepository) {
    return new JobBuilder(jobName, jobRepository).incrementer(new RunIdIncrementer())
        .listener(jobExecutionListener);
  }
}
