/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.referenceapps.util.util;

import jakarta.annotation.Nullable;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.referenceapps.util.record.RecordWithId;

public class MemoryDataStoreDao {
    private ServletContext context;
    private String dataKind;
    private static final String ROOT_KEY = "data";

    public MemoryDataStoreDao(ServletContext context, String dataKind) {
        this(context, dataKind, null);
    }

    public MemoryDataStoreDao(ServletContext context, String function, List<? extends RecordWithId> initialData) {
        this.context = context;
        this.dataKind = function;
        this.initinalize(this.dataKind, initialData);
    }

    private Map<String, List<? extends RecordWithId>> getRootMap() {
        return (Map)this.context.getAttribute(ROOT_KEY);
    }

    private void initinalize(String dataKind, @Nullable List<? extends RecordWithId> dataList) {
        if (this.context.getAttribute(ROOT_KEY) == null) {
            this.context.setAttribute(ROOT_KEY, new HashMap());
        }
        if (this.getRootMap().get(dataKind) == null) {
            this.getRootMap().put(dataKind, new ArrayList());
        }
        if (dataList != null) {
            this.getRootMap().put(dataKind, dataList);
        }
    }

    public List<RecordWithId> findAll() {
        return new ArrayList<RecordWithId>((Collection)this.getRootMap().get(this.dataKind));
    }

    public RecordWithId findById(String id) {
        List<RecordWithId> list = this.findAll().stream().filter(rec -> rec.getId().equals(id)).toList();
        return list.size() == 0 ? null : list.get(0);
    }

    public void insert(RecordWithId record) {
        List<RecordWithId> list = this.findAll();
        if (list.stream().filter(rec -> rec.getId().equals(record.getId())).toList().size() > 0) {
            throw new EclibRuntimeException("Record with specified ID duplicated.");
        }
        list.add(record);
        this.getRootMap().put(this.dataKind, list);
    }

    public void update(RecordWithId record) {
        if (this.findAll().stream().filter(rec -> rec.getId().equals(record.getId())).toList().size() == 0) {
            throw new EclibRuntimeException("Record with specified ID not found.");
        }
        ArrayList<RecordWithId> list = new ArrayList<RecordWithId>(this.findAll().stream().filter(rec -> !rec.getId().equals(record.getId())).toList());
        list.add(record);
        this.getRootMap().put(this.dataKind, list);
    }

    public void insertOrUpdate(RecordWithId record) {
        if (this.findAll().stream().filter(rec -> rec.getId().equals(record.getId())).toList().size() > 0) {
            this.update(record);
        } else {
            this.insert(record);
        }
    }

    public void delete(String id) throws BizLogicAppException {
        if (this.findAll().stream().filter(rec -> rec.getId().equals(id)).toList().size() == 0) {
            throw new BizLogicAppException("Record with specified ID not found.", new String[0]);
        }
        List<RecordWithId> list = this.findAll().stream().filter(rec -> !rec.getId().equals(id)).toList();
        this.getRootMap().put(this.dataKind, list);
    }

    public void deleteIfExists(String id) throws BizLogicAppException {
        if (this.findAll().stream().filter(rec -> rec.getId().equals(id)).toList().size() > 0) {
            this.delete(id);
        }
    }
}

