/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.validation.constraints.internal;

import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.constraints.ClassValidator;
import jp.ecuacion.lib.validation.constraints.enums.ConditionOperator;
import jp.ecuacion.lib.validation.constraints.enums.ConditionValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ConditionalValidator
extends ClassValidator {
    private String conditionPropertyPath;
    private ConditionValue conditionPattern;
    private ConditionOperator conditionOperator;
    private String[] conditionValueString;
    private String conditionValueRegexp;
    private String conditionValuePropertyPath;
    private boolean validatesWhenConditionNotSatisfied;
    private boolean satisfiesCondition = false;
    public static final String CONDITION_PROPERTY_PATH = "conditionPropertyPath";
    public static final String CONDITION_PROPERTY_PATH_ITEM_NAME_KEY = "conditionPropertyPathItemNameKey";
    public static final String CONDITION_PROPERTY_PATH_ITEM_NAME = "conditionPropertyPathItemName";
    public static final String CONDITION_PATTERN = "conditionPattern";
    public static final String CONDITION_OPERATOR = "conditionOperator";
    public static final String CONDITION_VALUE_STRING = "conditionValueString";
    public static final String CONDITION_VALUE_PROPERTY_PATH = "conditionValuePropertyPath";
    public static final String DISPLAY_STRING_OF_CONDITION_VALUE = "displayStringOfConditionValue";
    public static final String VALIDATES_WHEN_CONDITION_NOT_SATISFIED = "validatesWhenConditionNotSatisfied";

    public void initialize(String[] propertyPath, String conditionPropertyPath, ConditionValue conditionPattern, ConditionOperator conditionOperator, String[] conditionValueString, String conditionValuePattern, String conditionValuePropertyPath, boolean validatesWhenConditionNotSatisfied) {
        super.initialize(propertyPath);
        this.conditionPropertyPath = conditionPropertyPath;
        this.conditionPattern = conditionPattern;
        this.conditionOperator = conditionOperator;
        this.conditionValueString = conditionValueString;
        this.conditionValueRegexp = conditionValuePattern;
        this.conditionValuePropertyPath = conditionValuePropertyPath;
        this.validatesWhenConditionNotSatisfied = validatesWhenConditionNotSatisfied;
    }

    protected abstract boolean isValid(Object var1);

    public boolean isValid(Object instance, ConstraintValidatorContext context) {
        this.procedureBeforeLoopForEachPropertyPath(instance);
        List<Pair> valueOfFieldList = Arrays.asList(this.propertyPaths).stream().map(path -> Pair.of((Object)path, (Object)ConditionalValidator.getValue((Object)instance, (String)path))).toList();
        for (Pair pair : valueOfFieldList) {
            boolean result = this.isValidForSinglePropertyPath((String)pair.getLeft(), pair.getRight());
            if (result) continue;
            return false;
        }
        return true;
    }

    public void procedureBeforeLoopForEachPropertyPath(Object instance) {
        this.satisfiesCondition = this.getSatisfiesCondition(instance);
    }

    protected boolean isValidForSinglePropertyPath(String itemPropertyPath, Object valueOfField) {
        if (this.satisfiesCondition) {
            return this.isValid(valueOfField);
        }
        if (this.validatesWhenConditionNotSatisfied) {
            return this.isValidWhenConditionNotSatisfied(valueOfField);
        }
        return true;
    }

    boolean getSatisfiesCondition(Object instance) {
        Object valueOfConditionPropertyPath = ConditionalValidator.getValue((Object)instance, (String)this.conditionPropertyPath);
        if (this.conditionPattern == ConditionValue.EMPTY) {
            boolean isEmpty;
            this.conditionValueStringMustNotSet();
            this.conditionValueRegexpMustNotSet();
            this.conditionValueFieldMustNotSet();
            boolean bl = isEmpty = valueOfConditionPropertyPath == null || valueOfConditionPropertyPath instanceof String && ((String)valueOfConditionPropertyPath).equals("");
            if (isEmpty && this.conditionOperator == ConditionOperator.EQUAL_TO || !isEmpty && this.conditionOperator == ConditionOperator.NOT_EQUAL_TO) {
                return true;
            }
        } else {
            if (this.conditionPattern == ConditionValue.TRUE || this.conditionPattern == ConditionValue.FALSE) {
                this.conditionValueStringMustNotSet();
                this.conditionValueRegexpMustNotSet();
                this.conditionValueFieldMustNotSet();
                if (valueOfConditionPropertyPath != null && !(valueOfConditionPropertyPath instanceof Boolean)) {
                    throw new EclibRuntimeException("The data type of conditionPropertyPath must be boolean");
                }
                Boolean bl = (Boolean)valueOfConditionPropertyPath;
                boolean validWhenBooleanTrue = this.conditionOperator == ConditionOperator.EQUAL_TO && bl != null && bl != false || this.conditionOperator == ConditionOperator.NOT_EQUAL_TO && (bl == null || bl == false);
                boolean validWhenBooleanFalse = this.conditionOperator == ConditionOperator.EQUAL_TO && bl != null && bl == false || this.conditionOperator == ConditionOperator.NOT_EQUAL_TO && (bl == null || bl != false);
                return this.conditionPattern == ConditionValue.TRUE ? validWhenBooleanTrue : validWhenBooleanFalse;
            }
            if (this.conditionPattern == ConditionValue.STRING) {
                this.conditionValueRegexpMustNotSet();
                this.conditionValueFieldMustNotSet();
                if (valueOfConditionPropertyPath == null) {
                    valueOfConditionPropertyPath = "[null]";
                }
                if (!(valueOfConditionPropertyPath instanceof String)) {
                    throw new EclibRuntimeException("'valueOfConditionPropertyPath' must be String.");
                }
                boolean contains = Arrays.asList(this.conditionValueString).contains(valueOfConditionPropertyPath);
                if (contains && this.conditionOperator == ConditionOperator.EQUAL_TO || !contains && this.conditionOperator == ConditionOperator.NOT_EQUAL_TO) {
                    return true;
                }
            } else if (this.conditionPattern == ConditionValue.PATTERN) {
                this.conditionValueStringMustNotSet();
                this.conditionValueFieldMustNotSet();
                if (valueOfConditionPropertyPath == null || valueOfConditionPropertyPath instanceof String && StringUtils.isEmpty((CharSequence)((String)valueOfConditionPropertyPath))) {
                    return false;
                }
                if (!(valueOfConditionPropertyPath instanceof String)) {
                    throw new EclibRuntimeException("'valueOfConditionPropertyPath' must be String.");
                }
                if (this.conditionValueRegexp.equals("[null]")) {
                    throw new EclibRuntimeException("'conditionValuePattern' must be set.");
                }
                Pattern p = Pattern.compile(this.conditionValueRegexp);
                Matcher m = p.matcher((String)valueOfConditionPropertyPath);
                boolean satisfies = m.find();
                if (satisfies && this.conditionOperator == ConditionOperator.EQUAL_TO || !satisfies && this.conditionOperator == ConditionOperator.NOT_EQUAL_TO) {
                    return true;
                }
            } else if (this.conditionPattern == ConditionValue.VALUE_OF_PROPERTY_PATH) {
                boolean contains;
                Object firstValueOfConditionValueField;
                this.conditionValueStringMustNotSet();
                this.conditionValueRegexpMustNotSet();
                Object valueOfConditionValueField = ConditionalValidator.getValue((Object)instance, (String)this.conditionValuePropertyPath);
                ArrayList<Object> valueListOfConditionValueField = new ArrayList<Object>();
                if (valueOfConditionValueField instanceof Object[]) {
                    for (Object val : (Object[])valueOfConditionValueField) {
                        valueListOfConditionValueField.add(val);
                    }
                } else {
                    valueListOfConditionValueField.add(valueOfConditionValueField);
                }
                List<Object> nonnullList = valueListOfConditionValueField.stream().filter(v -> v != null).toList();
                Object object = firstValueOfConditionValueField = nonnullList.size() == 0 ? null : nonnullList.get(0);
                if (valueOfConditionPropertyPath != null && firstValueOfConditionValueField != null) {
                    Class<?> valueOfCf = valueOfConditionPropertyPath.getClass();
                    Class<?> firstValueOfCvfList = firstValueOfConditionValueField.getClass();
                    if (!firstValueOfCvfList.isAssignableFrom(valueOfCf)) {
                        throw new EclibRuntimeException("Datatype not match. valueOfConditionField: " + String.valueOf(valueOfConditionPropertyPath) + ", valueListOfConditionValueField.get(0): " + String.valueOf(firstValueOfConditionValueField));
                    }
                }
                valueListOfConditionValueField.replaceAll(x -> x == null ? "[null]" : x);
                boolean bl = contains = valueOfConditionPropertyPath == null && valueListOfConditionValueField.contains("[null]") || valueOfConditionPropertyPath != null && valueListOfConditionValueField.contains(valueOfConditionPropertyPath);
                if (contains && this.conditionOperator == ConditionOperator.EQUAL_TO || !contains && this.conditionOperator == ConditionOperator.NOT_EQUAL_TO) {
                    return true;
                }
            } else {
                throw new EclibRuntimeException("Unexpected.");
            }
        }
        return false;
    }

    protected boolean isValidWhenConditionNotSatisfied(Object valueOfField) {
        return true;
    }

    private void conditionValueFieldMustNotSet() {
        if (!this.conditionValuePropertyPath.equals("[null]")) {
            throw new EclibRuntimeException("You cannot set 'conditionValuePropertyPath' when 'conditionValue' is not 'VALUE_OF_PROPERTY_PATH'.");
        }
    }

    private void conditionValueStringMustNotSet() {
        if (!Arrays.asList(this.conditionValueString).contains("[null]")) {
            throw new EclibRuntimeException("You cannot set 'conditionValueString' when conditionValue is not 'STRING'.");
        }
    }

    private void conditionValueRegexpMustNotSet() {
        if (!this.conditionValueRegexp.equals("[null]")) {
            throw new EclibRuntimeException("You cannot set 'conditionValuePattern' when conditionValue is not 'PATTERN'.");
        }
    }
}

