/*
 * Copyright © 2012 ecuacion.jp (info@ecuacion.jp)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.ecuacion.lib.validation.constraints;

import jakarta.validation.ConstraintValidator;
import jp.ecuacion.lib.validation.constant.EclibValidationConstants;
import jp.ecuacion.lib.validation.constraints.internal.ConditionalValidator;
import org.apache.commons.lang3.StringUtils;

/**
 * Provides the validation logic for {@code ConditionalNotEmpty}.
 */
public class NotEmptyWhenValidator extends ConditionalValidator
    implements ConstraintValidator<NotEmptyWhen, Object> {

  /** Initializes an instance. */
  @Override
  public void initialize(NotEmptyWhen annotation) {
    super.initialize(annotation.propertyPath(), annotation.conditionPropertyPath(),
        annotation.conditionValue(), annotation.conditionOperator(),
        annotation.conditionValueString(), annotation.conditionValueRegexp(),
        annotation.conditionValuePropertyPath(), annotation.emptyWhenConditionNotSatisfied());
  }

  @Override
  protected boolean isValid(Object valueOfField) {
    if (valueOfField != null
        && valueOfField.equals(EclibValidationConstants.VALIDATOR_PARAMETER_NULL)) {
      valueOfField = null;
    }

    if (valueOfField != null && valueOfField instanceof String) {
      return !StringUtils.isEmpty((String) valueOfField);

    } else {
      return valueOfField != null;
    }
  }

  @Override
  protected boolean isValidWhenConditionNotSatisfied(Object valueOfField) {
    return !isValid(valueOfField);
  }
}
