/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.validation.constraints.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.validation.constraints.enums.ConditionOperator;
import jp.ecuacion.lib.validation.constraints.enums.ConditionValuePattern;
import jp.ecuacion.lib.validation.constraints.internal.ClassValidator;

public abstract class ConditionalValidator
extends ClassValidator {
    private String conditionPropertyPath;
    private ConditionValuePattern conditionPattern;
    private ConditionOperator conditionOperator;
    private String[] conditionValueString;
    private String conditionValuePropertyPath;
    private boolean validatesWhenConditionNotSatisfied;
    private boolean satisfiesCondition = false;
    public static final String CONDITION_PROPERTY_PATH = "conditionPropertyPath";
    public static final String CONDITION_PROPERTY_PATH_ITEM_NAME_KEY = "conditionPropertyPathItemNameKey";
    public static final String CONDITION_PROPERTY_PATH_ITEM_NAME = "conditionPropertyPathItemName";
    public static final String CONDITION_PATTERN = "conditionPattern";
    public static final String CONDITION_OPERATOR = "conditionOperator";
    public static final String CONDITION_VALUE_STRING = "conditionValueString";
    public static final String CONDITION_VALUE_PROPERTY_PATH = "conditionValuePropertyPath";
    public static final String DISPLAY_STRING_PROPERTY_PATH_OF_CONDITION_VALUE_PROPERTY_PATH = "displayStringPropertyPathOfConditionValuePropertyPath";
    public static final String DISPLAY_STRING_OF_CONDITION_VALUE = "displayStringOfConditionValue";
    public static final String VALIDATES_WHEN_CONDITION_NOT_SATISFIED = "validatesWhenConditionNotSatisfied";

    public void initialize(String[] propertyPath, String conditionPropertyPath, ConditionValuePattern conditionPattern, ConditionOperator conditionOperator, String[] conditionValueString, String conditionValuePropertyPath, boolean validatesWhenConditionNotSatisfied) {
        super.initialize(propertyPath);
        this.conditionPropertyPath = conditionPropertyPath;
        this.conditionPattern = conditionPattern;
        this.conditionOperator = conditionOperator;
        this.conditionValueString = conditionValueString;
        this.conditionValuePropertyPath = conditionValuePropertyPath;
        this.validatesWhenConditionNotSatisfied = validatesWhenConditionNotSatisfied;
    }

    protected abstract boolean isValid(Object var1);

    @Override
    public void procedureBeforeLoopForEachPropertyPath() {
        this.satisfiesCondition = this.getSatisfiesCondition(this.instance);
    }

    @Override
    protected boolean isValidForSinglePropertyPath(String itemPropertyPath, Object valueOfField) {
        if (this.satisfiesCondition) {
            return this.isValid(valueOfField);
        }
        if (this.validatesWhenConditionNotSatisfied) {
            return this.isValidWhenConditionNotSatisfied(valueOfField);
        }
        return true;
    }

    boolean getSatisfiesCondition(Object instance) {
        Object valueOfConditionField = ConditionalValidator.getValue((Object)instance, (String)this.conditionPropertyPath);
        if (this.conditionPattern == ConditionValuePattern.empty) {
            boolean isEmpty;
            this.conditionValueStringMustNotSet();
            this.conditionValueFieldMustNotSet();
            boolean bl = isEmpty = valueOfConditionField == null || valueOfConditionField instanceof String && ((String)valueOfConditionField).equals("");
            if (isEmpty && this.conditionOperator == ConditionOperator.equalTo || !isEmpty && this.conditionOperator == ConditionOperator.notEqualTo) {
                return true;
            }
        } else {
            if (this.conditionPattern == ConditionValuePattern.booleanTrue || this.conditionPattern == ConditionValuePattern.booleanFalse) {
                this.conditionValueStringMustNotSet();
                this.conditionValueFieldMustNotSet();
                if (valueOfConditionField != null && !(valueOfConditionField instanceof Boolean)) {
                    throw new EclibRuntimeException("The data type of conditionPropertyPath must be boolean");
                }
                Boolean bl = (Boolean)valueOfConditionField;
                boolean validWhenBooleanTrue = this.conditionOperator == ConditionOperator.equalTo && bl != null && bl != false || this.conditionOperator == ConditionOperator.notEqualTo && (bl == null || bl == false);
                boolean validWhenBooleanFalse = this.conditionOperator == ConditionOperator.equalTo && bl != null && bl == false || this.conditionOperator == ConditionOperator.notEqualTo && (bl == null || bl != false);
                return this.conditionPattern == ConditionValuePattern.booleanTrue ? validWhenBooleanTrue : validWhenBooleanFalse;
            }
            if (this.conditionPattern == ConditionValuePattern.valueOfPropertyPath) {
                boolean contains;
                Object firstValueOfConditionValueField;
                this.conditionValueStringMustNotSet();
                Object valueOfConditionValueField = ConditionalValidator.getValue((Object)instance, (String)this.conditionValuePropertyPath);
                ArrayList<Object> valueListOfConditionValueField = new ArrayList<Object>();
                if (valueOfConditionValueField instanceof Object[]) {
                    for (Object val : (Object[])valueOfConditionValueField) {
                        valueListOfConditionValueField.add(val);
                    }
                } else {
                    valueListOfConditionValueField.add(valueOfConditionValueField);
                }
                List<Object> nonnullList = valueListOfConditionValueField.stream().filter(v -> v != null).toList();
                Object object = firstValueOfConditionValueField = nonnullList.size() == 0 ? null : nonnullList.get(0);
                if (valueOfConditionField != null && firstValueOfConditionValueField != null) {
                    Class<?> valueOfCf = valueOfConditionField.getClass();
                    Class<?> firstValueOfCvfList = firstValueOfConditionValueField.getClass();
                    if (!firstValueOfCvfList.isAssignableFrom(valueOfCf)) {
                        throw new EclibRuntimeException("Datatype not match. valueOfConditionField: " + String.valueOf(valueOfConditionField) + ", valueListOfConditionValueField.get(0): " + String.valueOf(firstValueOfConditionValueField));
                    }
                }
                valueListOfConditionValueField.replaceAll(x -> x == null ? "[null]" : x);
                boolean bl = contains = valueOfConditionField == null && valueListOfConditionValueField.contains("[null]") || valueOfConditionField != null && valueListOfConditionValueField.contains(valueOfConditionField);
                if (contains && this.conditionOperator == ConditionOperator.equalTo || !contains && this.conditionOperator == ConditionOperator.notEqualTo) {
                    return true;
                }
            } else {
                this.conditionValueFieldMustNotSet();
                if (valueOfConditionField == null) {
                    valueOfConditionField = "[null]";
                }
                if (!(valueOfConditionField instanceof String)) {
                    throw new EclibRuntimeException("When 'conditionValue' is not null, 'validationConditionField' must be String.");
                }
                boolean contains = Arrays.asList(this.conditionValueString).contains(valueOfConditionField);
                if (contains && this.conditionOperator == ConditionOperator.equalTo || !contains && this.conditionOperator == ConditionOperator.notEqualTo) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isValidWhenConditionNotSatisfied(Object valueOfField) {
        return true;
    }

    private void conditionValueFieldMustNotSet() {
        if (!Arrays.asList(this.conditionValuePropertyPath).contains("[null]")) {
            throw new EclibRuntimeException("You cannot set 'conditionValueField' when howToDetermineConditionIsValid is not either 'valueOfConditionFieldIsEqualToValueOf' or 'valueOfConditionFieldIsNotEqualToValueOf'.");
        }
    }

    private void conditionValueStringMustNotSet() {
        if (!Arrays.asList(this.conditionValueString).contains("[null]")) {
            throw new EclibRuntimeException("You cannot set 'conditionValueString' when howToDetermineConditionIsValid is not either 'stringValueOfConditionFieldIsEqualTo' or 'stringValueOfConditionFieldIsNotEqualTo'.");
        }
    }
}

