/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.validation.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jp.ecuacion.lib.validation.constraints.EnumElement;
import org.apache.commons.lang3.StringUtils;

public class EnumElementValidator
implements ConstraintValidator<EnumElement, String> {
    private Class<?> enumClass;

    public void initialize(EnumElement constraintAnnotation) {
        this.enumClass = constraintAnnotation.enumClass();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        try {
            ?[] objs;
            if (!this.enumClass.isEnum()) {
                throw new RuntimeException("A class is found. An enum is supposed to be found: " + this.enumClass.getCanonicalName());
            }
            for (Object obj : objs = this.enumClass.getEnumConstants()) {
                if (!obj.toString().equals(value)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

