/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.jpa.entity;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class EclibEntity {
    @Nullable
    public Object getValue(@RequireNonnull String fieldName) {
        try {
            Method m = this.getClass().getMethod("get" + StringUtils.capitalize((String)fieldName), new Class[0]);
            Object value = m.invoke((Object)this, new Object[0]);
            return value;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public String getPkFieldName() {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            Id annotation = field.getAnnotation(Id.class);
            if (annotation == null) continue;
            return Objects.requireNonNull(field.getName());
        }
        throw new RuntimeException("Field with '@Id' not found.");
    }

    @Nonnull
    public Set<String> getAutoIncrementFieldNameSet() {
        Field[] fields = this.getClass().getDeclaredFields();
        HashSet<String> rtnSet = new HashSet<String>();
        for (Field field : fields) {
            GeneratedValue annotation = field.getAnnotation(GeneratedValue.class);
            if (annotation == null) continue;
            rtnSet.add(field.getName());
        }
        return rtnSet;
    }

    public boolean isAutoIncrement(@RequireNonnull String fieldName) {
        return this.getAutoIncrementFieldNameSet().contains(fieldName);
    }

    @Nonnull
    public Set<List<String>> getSetOfUniqueConstraintFieldList() {
        HashSet<List<String>> rtnSet = new HashSet<List<String>>();
        Table table = this.getClass().getAnnotation(Table.class);
        UniqueConstraint[] ucs = table.uniqueConstraints();
        if (ucs == null) {
            return rtnSet;
        }
        for (UniqueConstraint uc : ucs) {
            rtnSet.add(Arrays.asList(uc.columnNames()));
        }
        return rtnSet;
    }

    public boolean hasNaturalKey() {
        return this.getSetOfUniqueConstraintFieldList().size() != 0;
    }

    public abstract void preInsert();

    public abstract void preUpdate();

    public abstract boolean hasSoftDeleteField();

    public abstract String[] getFieldNameArr();
}

