/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class ValidationUtil {
    private ValidationUtil() {
    }

    @Nonnull
    public static <T> Set<ConstraintViolation<T>> validate(@RequireNonnull T object) {
        ObjectsUtil.paramRequireNonNull(object);
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        return validator.validate(object, new Class[0]);
    }

    public static ValidationExecutorBuilder builder() {
        return new ValidationExecutorBuilder();
    }

    public static class ValidationExecutorBuilder {
        private boolean isMessageWithItemName;
        private PropertyFileUtil.Arg messagePrefix;
        private PropertyFileUtil.Arg messagePostfix;

        @Nonnull
        public ValidationExecutorBuilder messageWithItemName(boolean isMessageWithItemName) {
            this.isMessageWithItemName = isMessageWithItemName;
            return this;
        }

        @Nonnull
        public ValidationExecutorBuilder messagePrefix(@RequireNonnull PropertyFileUtil.Arg messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        @Nonnull
        public ValidationExecutorBuilder messagePostfix(@RequireNonnull PropertyFileUtil.Arg messagePostfix) {
            this.messagePostfix = messagePostfix;
            return this;
        }

        @Nonnull
        public ValidationExecutor build() {
            return new ValidationExecutor(this.isMessageWithItemName, this.messagePrefix, this.messagePostfix);
        }
    }

    public static class ValidationExecutor {
        private boolean isMessageWithItemName;
        private PropertyFileUtil.Arg messagePrefix;
        private PropertyFileUtil.Arg messagePostfix;

        public ValidationExecutor(boolean isMessageWithItemName, @Nullable PropertyFileUtil.Arg messagePrefix, @Nullable PropertyFileUtil.Arg messagePostfix) {
            this.isMessageWithItemName = isMessageWithItemName;
            this.messagePrefix = messagePrefix;
            this.messagePostfix = messagePostfix;
        }

        public <T> void validateThenThrow(@RequireNonnull T object) throws MultipleAppException {
            MultipleAppException exList = this.validateThenReturn(object);
            if (exList != null && exList.getList().size() > 0) {
                throw exList;
            }
        }

        @Nullable
        public <T> MultipleAppException validateThenReturn(@RequireNonnull T object) {
            Set<ConstraintViolation<T>> set = ValidationUtil.validate(object);
            MultipleAppException exList = null;
            if (set != null && set.size() > 0) {
                ArrayList<ValidationAppException> list = new ArrayList<ValidationAppException>();
                for (ConstraintViolation<T> v : set) {
                    ValidationAppException bvex = new ValidationAppException(v).setMessageWithItemName(this.isMessageWithItemName);
                    if (this.messagePrefix != null) {
                        bvex.setMessagePrefix(this.messagePrefix);
                    }
                    if (this.messagePostfix != null) {
                        bvex.setMessagePostfix(this.messagePostfix);
                    }
                    list.add(bvex);
                }
                exList = new MultipleAppException(list);
            } else {
                exList = null;
            }
            return exList;
        }
    }
}

