/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import org.apache.commons.lang3.ArrayUtils;

public class ObjectsUtil {
    private ObjectsUtil() {
    }

    @Nonnull
    public static <T> T paramRequireNonNull(@RequireNonnull T object) {
        return Objects.requireNonNull(object, "[ecuacion-lib] [RuntimeException] ObjectsUtil#paramRequireNonNull(Object) : the argument is null.");
    }

    @Nonnull
    public static void paramRequireNonNull(@RequireNonnull Object object1, @RequireNonnull Object object2, Object ... objects) {
        Object[] allObjects;
        for (Object object : allObjects = ArrayUtils.addAll((Object[])objects, (Object[])new Object[]{object1, object2})) {
            Objects.requireNonNull(object, "[ecuacion-lib] [RuntimeException] ObjectsUtil#paramRequireNonNull(Object) : the argument is null.");
        }
    }

    @Nonnull
    public static <T> T returnRequireNonNull(@RequireNonnull T object) {
        return Objects.requireNonNull(object, "[ecuacion-lib] [RuntimeException] ObjectsUtil#returnRequireNonNull(Object) : the return value: " + object.getClass().getName() + "is null.");
    }

    @Nonnull
    public static <T> T requireNonNull(@RequireNonnull T object) {
        return Objects.requireNonNull(object, "[ecuacion-lib] [RuntimeException] ObjectsUtil#requireNonNull(Object) : the variable: " + object.getClass().getName() + "is null.");
    }

    @Nonnull
    public static <T> T[] paramSizeNonZero(@RequireNonnull T[] objects) {
        ObjectsUtil.paramRequireNonNull(objects);
        if (objects.length == 0) {
            throw new IllegalArgumentException("[ecuacion-lib] [RuntimeException] ObjectsUtil#paramSizeNonZero(T[]) : The length of the array is zero.");
        }
        return objects;
    }

    @Nonnull
    public static <T> Collection<T> paramSizeNonZero(@RequireNonnull Collection<T> colleciton) {
        ObjectsUtil.paramRequireNonNull(colleciton);
        if (colleciton.size() == 0) {
            throw new IllegalArgumentException("[ecuacion-lib] [RuntimeException] ObjectsUtil#paramSizeNonZero(Collection<T>) : The size of the collection is zero.");
        }
        return colleciton;
    }
}

