/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.logging;

import jakarta.annotation.Nullable;
import java.util.Locale;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.logging.internal.EclibLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.slf4j.event.Level;

public class ErrorLogger
extends EclibLogger {
    public ErrorLogger() {
        super("error-logger");
    }

    public void info(@RequireNonnull String message) {
        this.log(Level.INFO, message);
    }

    public void warn(@RequireNonnull String message) {
        this.log(Level.WARN, message);
    }

    public void error(@RequireNonnull String message) {
        this.log(Level.ERROR, message);
    }

    public void logSystemError(@RequireNonnull Throwable throwable) {
        this.logSystemError(throwable, null);
    }

    public void logSystemError(@RequireNonnull Throwable throwable, @Nullable String additionalMessage) {
        ObjectsUtil.paramRequireNonNull(throwable);
        String msg = throwable.getMessage() == null ? "" : " - " + ExceptionUtil.getExceptionMessage(throwable, Locale.ENGLISH, true).toString().replace("\n", " ");
        this.internalLogger.error("A system error has occurred: " + throwable.getClass().getName() + msg + " (" + additionalMessage + ")");
    }
}

