/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.regex.Pattern;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    @Nullable
    public String getLowerCamelFromSnakeOrNullIfInputIsNull(@Nullable String snakeCaseString) {
        if (snakeCaseString == null) {
            return null;
        }
        if (snakeCaseString.startsWith("_")) {
            throw new EclibRuntimeException("snake-case string cannot start with '_'. (argment string: '" + snakeCaseString + "')");
        }
        if (snakeCaseString.endsWith("_")) {
            throw new EclibRuntimeException("snake-case string cannot end with '_'. (argment string: '" + snakeCaseString + "')");
        }
        if (snakeCaseString.contains("__")) {
            throw new EclibRuntimeException("snake-case strings are not supposed to have '__' (double underscores). (argument string: '" + snakeCaseString + "')");
        }
        Pattern pattern = Pattern.compile("^[A-Z_]*$");
        if (pattern.matcher(snakeCaseString).find()) {
            snakeCaseString = snakeCaseString.toLowerCase();
        }
        Object lowStr = StringUtils.uncapitalize((String)snakeCaseString);
        while (((String)lowStr).indexOf("_") >= 0) {
            int firstUsPos = ((String)lowStr).indexOf("_");
            lowStr = ((String)lowStr).substring(0, firstUsPos) + ((String)lowStr).substring(firstUsPos + 1, firstUsPos + 2).toUpperCase() + ((String)lowStr).substring(firstUsPos + 2);
        }
        return lowStr;
    }

    @Nullable
    public String getUpperCamelFromSnakeOrNullIfInputIsNull(@Nullable String snakeCaseString) {
        return StringUtils.capitalize((String)this.getLowerCamelFromSnakeOrNullIfInputIsNull(snakeCaseString));
    }

    @Nullable
    public String getLowerSnakeFromCamel(@Nullable String camelCaseString) {
        char[] chars;
        if (camelCaseString == null) {
            return null;
        }
        camelCaseString = StringUtils.uncapitalize((String)camelCaseString);
        for (char c : chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            String s = String.valueOf(c);
            camelCaseString = camelCaseString.replaceAll(s, "_" + s);
        }
        return camelCaseString;
    }

    @Nonnull
    public String toCurrencyFormat(@Nonnull String number) {
        if (number == null || number.equals("")) {
            throw new NumberFormatException();
        }
        NumberFormat formatter = NumberFormat.getNumberInstance();
        return formatter.format(Integer.valueOf(number));
    }

    private static String getCsv(String[] array, String separator) {
        boolean isFirstTime = true;
        StringBuilder sb = new StringBuilder();
        for (String str : array) {
            if (isFirstTime) {
                isFirstTime = false;
            } else {
                sb.append(separator);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @Nonnull
    public static String getCsv(String ... array) {
        return StringUtil.getCsv(array, ",");
    }

    @Nonnull
    public static String getCsv(@RequireNonnull Collection<String> collection) {
        return StringUtil.getCsv(collection.toArray(new String[collection.size()]));
    }

    @Nonnull
    public static String getCsvWithSpace(@RequireNonnull String[] array) {
        return StringUtil.getCsv(array, ", ");
    }

    @Nonnull
    public static String getCsvWithSpace(@RequireNonnull Collection<String> collection) {
        return StringUtil.getCsvWithSpace(collection.toArray(new String[collection.size()]));
    }

    @Nonnull
    public String escapeHtml(@Nonnull String str) {
        StringBuffer result = new StringBuffer();
        block8: for (char c : str.toCharArray()) {
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block8;
                }
                case ' ': {
                    result.append("&nbsp;");
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

