/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.logging.ErrorLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.slf4j.event.Level;

public class LogUtil {
    private DetailLogger detailLog;
    private ErrorLogger errLog = new ErrorLogger();
    private ExceptionUtil exUtil = new ExceptionUtil();
    public static final String PARTITION_LARGE = "===============";
    public static final String PARTITION_MEDIUM = "----------";

    public LogUtil(@Nonnull Object instance) {
        this.detailLog = new DetailLogger(ObjectsUtil.paramRequireNonNull(instance));
    }

    public LogUtil(@Nonnull Class<?> cls) {
        this.detailLog = new DetailLogger(ObjectsUtil.paramRequireNonNull(cls));
    }

    public void logError(@RequireNonnull Throwable throwable) {
        this.logError(throwable, (String)null);
    }

    public void logError(@RequireNonnull Throwable throwable, @Nullable Locale locale) {
        this.logError(throwable, null, locale);
    }

    public void logError(@RequireNonnull Throwable throwable, @Nullable String additionalMessage) {
        this.logError(throwable, additionalMessage, null);
    }

    public void logError(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale) {
        this.logException(Level.ERROR, throwable, additionalMessage, locale);
    }

    public void logDebug(@RequireNonnull Throwable throwable) {
        this.logException(Level.DEBUG, throwable, null, null);
    }

    private void logException(@Nonnull Level logLevel, @RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale) {
        ObjectsUtil.paramRequireNonNull(throwable);
        String msg = throwable.getMessage() == null ? "" : " - " + this.exUtil.getExceptionMessage(throwable, locale, true).toString().replace("\n", " ");
        this.errLog.error("A system error has occured: " + throwable.getClass().getName() + msg + " (" + (String)additionalMessage + ")");
        if (throwable instanceof AppException || throwable instanceof UncheckedAppException) {
            StringBuilder sb = new StringBuilder();
            AppException ae = throwable instanceof UncheckedAppException ? (AppException)((UncheckedAppException)throwable).getCause() : (AppException)throwable;
            new ExceptionUtil().getAppExceptionMessageList(ae, Locale.getDefault()).forEach(tmpMsg -> sb.append(tmpMsg + "\n"));
            additionalMessage = (String)additionalMessage + "\n" + sb.toString();
        }
        this.log(logLevel, this.exUtil.getErrLogString(throwable, (String)additionalMessage, locale));
    }

    private void log(@Nonnull Level logLevel, String message) {
        switch (logLevel) {
            case ERROR: {
                this.detailLog.error(message);
                break;
            }
            case WARN: {
                this.detailLog.warn(message);
                break;
            }
            case INFO: {
                this.detailLog.info(message);
                break;
            }
            case DEBUG: {
                this.detailLog.debug(message);
                break;
            }
            case TRACE: {
                this.detailLog.trace(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(logLevel));
            }
        }
    }
}

