/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.jakartavalidation.bean.ConstraintViolationBean;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtil {
    private static final String RT = "\n";

    @Nonnull
    public List<String> getExceptionMessage(@RequireNonnull Throwable throwable, boolean needsDetails) {
        return this.getExceptionMessage(throwable, Locale.getDefault(), needsDetails);
    }

    @Nonnull
    public List<String> getExceptionMessage(@RequireNonnull Throwable throwable, @Nullable Locale locale, boolean needsDetails) {
        ObjectsUtil.paramRequireNonNull(throwable);
        locale = locale == null ? Locale.getDefault() : locale;
        ObjectsUtil.paramRequireNonNull(needsDetails);
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        ArrayList<String> rtnList = new ArrayList<String>();
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)throwable;
            for (ConstraintViolation cv : cve.getConstraintViolations()) {
                exList.add(new ValidationAppException(cv));
            }
        } else {
            exList.add(throwable);
        }
        for (Throwable th : exList) {
            SingleAppException ex;
            if (th instanceof MultipleAppException) continue;
            if (th instanceof BizLogicAppException) {
                ex = (BizLogicAppException)th;
                rtnList.add(PropertyFileUtil.getMsg(locale, ((BizLogicAppException)ex).getMessageId(), ((BizLogicAppException)ex).getMessageArgs()));
                continue;
            }
            if (th instanceof ValidationAppException) {
                ex = (ValidationAppException)th;
                Object message = null;
                try {
                    ConstraintViolationBean bean = ((ValidationAppException)ex).getConstraintViolationBean();
                    HashMap<String, Object> map = new HashMap<String, Object>(bean.getParamMap());
                    Object object = message = ((ValidationAppException)ex).isMessageWithItemName() ? PropertyFileUtil.getValidationMessageWithItemName(locale, bean.getMessageTemplate(), map) : PropertyFileUtil.getValidationMessage(locale, bean.getMessageTemplate(), map);
                    if (((String)message).contains("{0}")) {
                        String className = bean.getRootClassName().substring(bean.getRootClassName().lastIndexOf(".") + 1);
                        Object itemName = StringUtils.uncapitalize((String)className) + "." + bean.getPropertyPath();
                        if (((String)itemName).split("\\.").length > 2) {
                            while (((String)(itemName = ((String)itemName).substring(((String)itemName).indexOf(".") + 1))).split("\\.").length != 2) {
                            }
                        }
                        if (PropertyFileUtil.hasItemName((String)itemName)) {
                            itemName = PropertyFileUtil.getItemName(locale, (String)itemName);
                        }
                        try {
                            message = MessageFormat.format((String)message, itemName);
                        }
                        catch (IllegalArgumentException iae) {
                            String msg = "ExceptionUtil#getExceptionMessage: MessageFormat.format throws an IllegalArgumentException because message template has {x} with x not a number. (message template: " + (String)message + ")";
                            throw new EclibRuntimeException(msg, iae);
                        }
                    }
                    if (((ValidationAppException)ex).getMessagePrefix() != null) {
                        message = PropertyFileUtil.getStringFromArg(locale, ((ValidationAppException)ex).getMessagePrefix()) + (String)message;
                    }
                    if (((ValidationAppException)ex).getMessagePostfix() != null) {
                        message = (String)message + PropertyFileUtil.getStringFromArg(locale, ((ValidationAppException)ex).getMessagePostfix());
                    }
                }
                catch (MissingResourceException mre) {
                    message = ex.getMessage();
                }
                rtnList.add((String)(needsDetails ? (String)message + RT + ((ValidationAppException)ex).toString() : message));
                continue;
            }
            rtnList.add(th.getMessage());
        }
        return rtnList;
    }

    @Nonnull
    private List<Throwable> serializeExceptions(@RequireNonnull Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        this.recursivelySerializeException(throwable, list);
        return ObjectsUtil.returnRequireNonNull(list);
    }

    private void recursivelySerializeException(@RequireNonnull Throwable throwable, List<Throwable> arr) {
        arr.add(throwable);
        if (throwable instanceof MultipleAppException) {
            for (AppException appException : ((MultipleAppException)throwable).getList()) {
                this.recursivelySerializeException(appException, arr);
            }
        } else if (throwable.getCause() != null) {
            this.recursivelySerializeException(throwable.getCause(), arr);
        }
    }

    @Nonnull
    public List<Throwable> getExceptionListWithMessages(@RequireNonnull Throwable throwable) {
        ObjectsUtil.paramRequireNonNull(throwable);
        ArrayList<Throwable> rtnList = new ArrayList<Throwable>();
        for (Throwable th : this.serializeExceptions(throwable)) {
            if (th instanceof MultipleAppException) continue;
            if (th instanceof UncheckedAppException) {
                rtnList.add(((UncheckedAppException)th).getCause());
                continue;
            }
            if (!(th instanceof SingleAppException) && !(th instanceof EclibRuntimeException) && (th.getMessage() == null || th.getMessage().equals(""))) continue;
            rtnList.add(th);
        }
        return rtnList;
    }

    @Nonnull
    public List<SingleAppException> getSingleAppExceptionList(@RequireNonnull AppException appException) {
        ObjectsUtil.paramRequireNonNull(appException);
        ArrayList<SingleAppException> rtnList = new ArrayList<SingleAppException>();
        this.serializeExceptions(appException).forEach(ex -> {
            if (ex instanceof SingleAppException) {
                rtnList.add((SingleAppException)ex);
            }
        });
        if (rtnList.isEmpty()) {
            throw new RuntimeException(appException);
        }
        return rtnList;
    }

    @Nonnull
    public List<String> getAppExceptionMessageList(@RequireNonnull AppException appException, @Nullable Locale locale) {
        ArrayList<String> rtnList = new ArrayList<String>();
        this.getSingleAppExceptionList(appException).stream().map(ex -> this.getExceptionMessage((Throwable)ex, locale, false)).forEach(list -> rtnList.addAll((Collection<String>)list));
        return rtnList;
    }

    @Nonnull
    public String getErrLogShortString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale, int packagesShown) {
        return this.getErrLogString(throwable, additionalMessage, locale, packagesShown);
    }

    @Nonnull
    public String getErrLogString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale) {
        return this.getErrLogString(throwable, additionalMessage, locale, null);
    }

    @Nonnull
    private String getErrLogString(@RequireNonnull Throwable throwable, @Nullable String additionalMessage, @Nullable Locale locale, Integer packagesShown) {
        ObjectsUtil.paramRequireNonNull(throwable);
        locale = locale == null ? Locale.getDefault() : locale;
        StringBuilder sb = new StringBuilder();
        sb.append("=============== system error occured ===============\n");
        if (additionalMessage != null) {
            sb.append(additionalMessage + RT);
            sb.append(RT);
        }
        sb.append(RT);
        this.getErrInfoRecursively(sb, throwable, locale, packagesShown);
        return sb.toString();
    }

    private void getErrInfoRecursively(StringBuilder sb, Throwable th, Locale locale, Integer packagesShown) {
        locale = locale == null ? Locale.getDefault() : locale;
        sb.append(th.getClass().getName() + RT);
        String errMsg = this.getExceptionMessage(th, locale, true).toString();
        if (errMsg != null) {
            sb.append(errMsg + RT);
        }
        sb.append(this.getStackTraceString(th, packagesShown));
        if (th.getCause() != null) {
            this.getErrInfoRecursively(sb, th.getCause(), locale, packagesShown);
        }
    }

    private String getStackTraceString(Throwable th, Integer packagesShown) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : th.getStackTrace()) {
            String[] spl = ste.getClassName().split("\\.");
            Object packageAndClass = ste.getClassName();
            if (packagesShown != null) {
                Object packages = "";
                for (int i = 0; i < packagesShown; ++i) {
                    if (spl.length <= i) continue;
                    packages = (String)packages + spl[i] + (spl.length - 1 == i ? "" : ".");
                }
                packageAndClass = (String)packages + (spl.length > packagesShown ? "." : "");
            }
            sb.append("\tat " + (String)packageAndClass + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")\n");
        }
        return sb.toString();
    }
}

