/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;

public class ObjectsUtil {
    @Nonnull
    public static <T> T paramRequireNonNull(@RequireNonnull T object) {
        return Objects.requireNonNull(object, "[ecuacion][RuntimeException] ObjectsUtil#paramRequireNonNull(Object) : the argument is null.");
    }

    @Nonnull
    public static <T> T returnRequireNonNull(@Nonnull T object) {
        return Objects.requireNonNull(object, "[ecuacion][RuntimeException] ObjectsUtil#returnRequireNonNull(Object) : the return value: " + object.getClass().getName() + "is null.");
    }

    @Nonnull
    public static <T> T requireNonNull(@RequireNonnull T object) {
        return Objects.requireNonNull(object, "[ecuacion][RuntimeException] ObjectsUtil#requireNonNull(Object) : the variable: " + object.getClass().getName() + "is null.");
    }

    @Nonnull
    public static <T> T[] paramSizeNonZero(@Nonnull T[] objects) {
        ObjectsUtil.paramRequireNonNull(objects);
        if (objects.length == 0) {
            throw new IllegalArgumentException("[ecuacion][RuntimeException] ObjectsUtil#paramSizeNonZero(T[]) : The length of the array is zero.");
        }
        return objects;
    }

    @Nonnull
    public static <T> Collection<T> paramSizeNonZero(@Nonnull Collection<T> colleciton) {
        ObjectsUtil.paramRequireNonNull(colleciton);
        if (colleciton.size() == 0) {
            throw new IllegalArgumentException("[ecuacion][RuntimeException] ObjectsUtil#paramSizeNonZero(Collection<T>) : The size of the collection is zero.");
        }
        return colleciton;
    }
}

