/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.bean;

import jakarta.annotation.Nonnull;
import jakarta.validation.ConstraintViolation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.core.jakartavalidation.util.internal.PrivateFieldReader;
import jp.ecuacion.lib.core.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class ConstraintViolationBean
extends PrivateFieldReader {
    private ConstraintViolation<?> cv;
    private String message;
    private String propertyPath;
    private String validatorClass;
    private String rootClassName;
    private String messageTemplate;
    private String annotationDescriptionString;
    private String[] itemIds;
    @Nonnull
    private Map<String, Object> paramMap;
    private static final String CONDITIONAL_VALIDATOR_PREFIX = "jp.ecuacion.lib.core.jakartavalidation.validator.Conditional";

    public ConstraintViolationBean(ConstraintViolation<?> cv) {
        this.cv = cv;
        this.message = cv.getMessage();
        this.propertyPath = cv.getPropertyPath().toString();
        this.validatorClass = cv.getConstraintDescriptor().getAnnotation().annotationType().getName();
        this.rootClassName = cv.getRootBeanClass().getName();
        this.annotationDescriptionString = cv.getConstraintDescriptor().getAnnotation().toString();
        this.messageTemplate = cv.getMessageTemplate();
        if (this.messageTemplate.startsWith("{")) {
            this.messageTemplate = this.messageTemplate.replace("{", "").replace("}", "");
        }
        Map<String, Object> map = this.paramMap = cv.getConstraintDescriptor().getAttributes() == null ? new HashMap<String, Object>() : new HashMap(cv.getConstraintDescriptor().getAttributes());
        if (this.paramMap.containsKey("field")) {
            String itemIdClass;
            this.itemIds = (String[])this.paramMap.get("field");
            String string = itemIdClass = this.paramMap.containsKey("itemIdClass") ? (String)this.paramMap.get("itemIdClass") : null;
            if (StringUtils.isNotEmpty(itemIdClass)) {
                List<String> itemIdList = Arrays.asList(this.itemIds).stream().map(id -> itemIdClass + (String)(id.lastIndexOf(".") > 0 ? id.substring(id.lastIndexOf(".")) : "." + id)).toList();
                this.itemIds = itemIdList.toArray(new String[itemIdList.size()]);
            }
        } else {
            this.itemIds = new String[]{this.propertyPath};
        }
        this.paramMap.put("itemIds", this.itemIds);
        this.putAdditionalParamsToParamMap(cv);
    }

    public ConstraintViolationBean(String message, String validatorClass, String rootClassName, String ... itemIds) {
        this.message = message;
        this.validatorClass = validatorClass;
        this.rootClassName = rootClassName;
        this.messageTemplate = validatorClass + ".message";
        this.itemIds = itemIds;
        this.propertyPath = itemIds[0];
        this.paramMap = new HashMap<String, Object>();
        this.annotationDescriptionString = "";
    }

    private void putAdditionalParamsToParamMap(ConstraintViolation<?> cv) {
        this.paramMap.put("leafClassName", this.getLeafClassName());
        this.paramMap.put("invalidValue", this.getInvalidValue());
        this.paramMap.put("annotation", this.getAnnotation());
        if (this.getAnnotation().startsWith(CONDITIONAL_VALIDATOR_PREFIX)) {
            String conditionValueKind;
            String valuesOfConditionFieldToValidate = null;
            if (((Boolean)this.paramMap.get("conditionValueIsEmpty")).booleanValue()) {
                conditionValueKind = "conditionValueIsEmpty";
            } else if (((Boolean)this.paramMap.get("conditionValueIsNotEmpty")).booleanValue()) {
                conditionValueKind = "conditionValueIsNotEmpty";
            } else if (!((String)this.paramMap.get("fieldHoldingConditionValue")).equals("[null]")) {
                conditionValueKind = "fieldHoldingConditionValue";
                Object obj = ConstraintViolationBean.getFieldValue((String)this.paramMap.get("fieldHoldingConditionValue"), this.getInstance(), conditionValueKind);
                valuesOfConditionFieldToValidate = obj instanceof String[] ? StringUtil.getCsvWithSpace((String[])obj) : (String)obj;
            } else {
                conditionValueKind = "conditionValue";
                String[] strs = (String[])this.paramMap.get(conditionValueKind);
                valuesOfConditionFieldToValidate = StringUtil.getCsvWithSpace(strs);
            }
            String fieldHoldingConditionValueDisplayName = (String)this.paramMap.get("fieldHoldingConditionValueDisplayName");
            if (!fieldHoldingConditionValueDisplayName.equals("")) {
                String[] strs = (String[])ConstraintViolationBean.getFieldValue(fieldHoldingConditionValueDisplayName, this.getInstance(), "fieldHoldingConditionValueDisplayName");
                valuesOfConditionFieldToValidate = StringUtil.getCsvWithSpace(strs);
            }
            this.paramMap.put("conditionValueKind", conditionValueKind);
            this.paramMap.put("valuesOfConditionFieldToValidate", valuesOfConditionFieldToValidate);
            boolean bl = this.getAnnotation().endsWith("ConditionalEmpty") && (Boolean)this.paramMap.get("notEmptyForOtherValues") != false || this.getAnnotation().endsWith("ConditionalNotEmpty") && (Boolean)this.paramMap.get("emptyForOtherValues") != false;
            this.paramMap.put("validatesWhenConditionNotSatisfied", bl);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getValidatorClass() {
        return this.validatorClass;
    }

    public String getAnnotationDescriptionString() {
        return this.annotationDescriptionString;
    }

    public String getAnnotation() {
        return this.cv.getConstraintDescriptor().getAnnotation().annotationType().getCanonicalName();
    }

    public Map<String, Object> getAnnotationAttributes() {
        return this.cv.getConstraintDescriptor().getAttributes();
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public String getLeafClassName() {
        return this.cv.getLeafBean().getClass().getName();
    }

    public String getInvalidValue() {
        return this.cv.getInvalidValue() == null ? "null" : this.cv.getInvalidValue().toString();
    }

    @Nonnull
    public String getMessageId() {
        return this.getAnnotation();
    }

    public Object getInstance() {
        return this.cv.getLeafBean();
    }

    public String[] getItemIds() {
        return this.itemIds;
    }

    @Nonnull
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }
}

