/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.exception.checked;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppExceptionFields;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class BizLogicAppException
extends SingleAppException {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private String messageId;
    @Nonnull
    private PropertyFileUtil.Arg[] messageArgs;
    @Nullable
    private AppExceptionFields fields;

    public BizLogicAppException(@Nonnull String messageId, String ... messageArgs) {
        this((AppExceptionFields)null, messageId, messageArgs);
    }

    public BizLogicAppException(@Nullable AppExceptionFields fields, @Nonnull String messageId, String ... messageArgs) {
        this(fields, ObjectsUtil.paramRequireNonNull(messageId), Arrays.asList(ObjectsUtil.paramRequireNonNull(messageArgs)).stream().map(arg -> PropertyFileUtil.Arg.string(arg)).toList().toArray(new PropertyFileUtil.Arg[messageArgs.length]));
    }

    public BizLogicAppException(@RequireNonnull String messageId, @RequireNonnull PropertyFileUtil.Arg[] messageArgs) {
        this(null, messageId, messageArgs);
    }

    public BizLogicAppException(@Nullable AppExceptionFields fields, @RequireNonnull String messageId, @RequireNonnull PropertyFileUtil.Arg[] messageArgs) {
        this.fields = fields;
        this.messageId = ObjectsUtil.paramRequireNonNull(messageId);
        this.messageArgs = messageArgs;
    }

    @Override
    public String getMessage() {
        return PropertyFileUtil.getMessage(this.messageId, this.messageArgs);
    }

    @Nullable
    public AppExceptionFields getErrorFields() {
        return this.fields;
    }

    @Nonnull
    public String getMessageId() {
        return this.messageId;
    }

    @Nonnull
    public PropertyFileUtil.Arg[] getMessageArgs() {
        return this.messageArgs == null ? new PropertyFileUtil.Arg[]{} : this.messageArgs;
    }
}

