/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.tuple.Pair;

public class FileLockUtil {
    public static Pair<FileChannel, FileLock> lock(File lockFile, String version) throws IOException {
        String fileTimestamp;
        FileLock lockedObject = null;
        FileChannel channel = FileChannel.open(lockFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        lockedObject = channel.tryLock();
        if (lockedObject == null) {
            throw new OverlappingFileLockException();
        }
        if (version != null && !version.equals(fileTimestamp = FileLockUtil.getLockFileVersion(lockFile))) {
            throw new OverlappingFileLockException();
        }
        return Pair.of((Object)channel, (Object)lockedObject);
    }

    public static void release(Pair<FileChannel, FileLock> channelAndLock) throws IOException {
        FileChannel channel = (FileChannel)channelAndLock.getLeft();
        FileLock lockedObject = (FileLock)channelAndLock.getRight();
        try {
            byte[] bytes = LocalDateTime.now().toString().getBytes();
            ByteBuffer src = ByteBuffer.allocate(bytes.length);
            src.put(bytes);
            src.position(0);
            channel.write(src);
            lockedObject.release();
        }
        catch (OverlappingFileLockException ex) {
            throw new OverlappingFileLockException();
        }
    }

    public static String getLockFileVersion(File lockFile) throws IOException {
        lockFile.getParentFile().mkdirs();
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        return Instant.ofEpochMilli(lockFile.lastModified()).atOffset(ZoneOffset.ofHours(0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS"));
    }
}

