/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.validator.internal;

import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.util.internal.PrivateFieldReader;
import org.apache.commons.lang3.StringUtils;

public abstract class ConditionalValidator
extends PrivateFieldReader {
    private String field;
    private String conditionField;
    private String[] conditionValue;
    private boolean conditionValueIsEmpty;
    private boolean conditionValueIsNotEmpty;
    private String fieldHoldingConditionValue;
    public static final String VALIDATION_TARGET_FIELD = "validationTargetField";
    public static final String CONDITION_FIELD = "conditionField";
    public static final String CONDITION_VALUE = "conditionValue";
    public static final String CONDITION_VALUE_IS_EMPTY = "conditionValueIsEmpty";
    public static final String CONDITION_VALUE_IS_NOT_EMPTY = "conditionValueIsNotEmpty";
    public static final String FIELD_HOLDING_CONDITOION_VALUE = "fieldHoldingConditionValue";
    public static final String CONDITION_VALUE_KIND = "conditionValueKind";
    public static final String VALUE_OF_CONDITION_FIELD_TO_VALIDATE = "valuesOfConditionFieldToValidate";

    public void initialize(String field, String conditionField, String[] conditionValue, boolean conditionValueIsEmpty, boolean conditionValueIsNotEmpty, String fieldHoldingConditionValue) {
        this.field = field;
        this.conditionField = conditionField;
        this.conditionValue = conditionValue;
        this.conditionValueIsEmpty = conditionValueIsEmpty;
        this.conditionValueIsNotEmpty = conditionValueIsNotEmpty;
        this.fieldHoldingConditionValue = fieldHoldingConditionValue;
    }

    protected abstract boolean isValid(Object var1);

    public boolean isValid(Object instance, ConstraintValidatorContext context) {
        Object valueOfField = ConditionalValidator.getFieldValue(this.field, instance, VALIDATION_TARGET_FIELD);
        Object valueOfConditionField = ConditionalValidator.getFieldValue(this.conditionField, instance, CONDITION_FIELD);
        if (this.conditionValue.length != 1 || !this.conditionValue[0].equals("[null]")) {
            this.conditionValueIsEmptyMustBeFalse(CONDITION_VALUE);
            this.conditionValueIsNotEmptyMustBeFalse(CONDITION_VALUE);
            this.fieldHoldingConditionalValueMustBeNull(CONDITION_VALUE);
            if (valueOfConditionField != null) {
                if (!(valueOfConditionField instanceof String)) {
                    throw new EclibRuntimeException("When 'conditionValue' is not null, 'validationConditionField' must be String.");
                }
                if (Arrays.asList(this.conditionValue).contains(valueOfConditionField)) {
                    return this.isValid(valueOfField);
                }
            }
        } else if (this.conditionValueIsEmpty) {
            this.conditionValueIsNotEmptyMustBeFalse("conditionValueIsEmpty = true");
            this.fieldHoldingConditionalValueMustBeNull("conditionValueIsEmpty = true");
            if (valueOfConditionField instanceof String && StringUtils.isEmpty((CharSequence)((String)valueOfConditionField)) || valueOfConditionField == null) {
                return this.isValid(valueOfField);
            }
        } else if (this.conditionValueIsNotEmpty) {
            this.fieldHoldingConditionalValueMustBeNull("conditionValueIsNotEmpty = true");
            if (valueOfConditionField instanceof String && !StringUtils.isEmpty((CharSequence)((String)valueOfConditionField)) || valueOfConditionField != null) {
                return this.isValid(valueOfField);
            }
        } else if (this.fieldHoldingConditionValue.equals("[null]")) {
            if (valueOfConditionField == null) {
                return this.isValid(valueOfField);
            }
        } else {
            Object valueOfFieldHoldingConditionalValue = ConditionalValidator.getFieldValue(this.fieldHoldingConditionValue, instance, FIELD_HOLDING_CONDITOION_VALUE);
            if (valueOfConditionField == null && valueOfFieldHoldingConditionalValue == null || valueOfConditionField != null && valueOfFieldHoldingConditionalValue.equals(valueOfConditionField)) {
                return this.isValid(valueOfField);
            }
        }
        return true;
    }

    private void conditionValueIsEmptyMustBeFalse(String prerequisite) {
        if (this.conditionValueIsEmpty) {
            throw new EclibRuntimeException("When you set '" + prerequisite + "', you cannot set 'conditionValueIsEmpty = true'.");
        }
    }

    private void conditionValueIsNotEmptyMustBeFalse(String prerequisite) {
        if (this.conditionValueIsNotEmpty) {
            throw new EclibRuntimeException("When you set '" + prerequisite + "', you cannot set 'conditionValueIsNotEmpty = true'.");
        }
    }

    private void fieldHoldingConditionalValueMustBeNull(String prerequisite) {
        if (!this.fieldHoldingConditionValue.equals("[null]")) {
            throw new EclibRuntimeException("When you set '" + prerequisite + "', you cannot set 'fieldHoldingConditionValue'.");
        }
    }
}

