/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.jakartavalidation.bean;

import jakarta.annotation.Nonnull;
import jakarta.validation.ConstraintViolation;
import java.util.HashMap;
import java.util.Map;
import jp.ecuacion.lib.core.jakartavalidation.util.internal.PrivateFieldReader;

public class ConstraintViolationBean
extends PrivateFieldReader {
    private ConstraintViolation<?> cv;
    private String message;
    private String propertyPath;
    private String validatorClass;
    private String rootClassName;
    private String messageTemplate;
    private String annotationDescriptionString;
    @Nonnull
    private Map<String, Object> paramMap;

    public ConstraintViolationBean(ConstraintViolation<?> cv) {
        this.cv = cv;
        this.message = cv.getMessage();
        this.propertyPath = cv.getPropertyPath().toString();
        this.validatorClass = cv.getConstraintDescriptor().getAnnotation().annotationType().getName();
        this.rootClassName = cv.getRootBeanClass().getName();
        this.annotationDescriptionString = cv.getConstraintDescriptor().getAnnotation().toString();
        this.messageTemplate = cv.getMessageTemplate();
        if (this.messageTemplate.startsWith("{")) {
            this.messageTemplate = this.messageTemplate.replace("{", "").replace("}", "");
        }
        this.paramMap = cv.getConstraintDescriptor().getAttributes() == null ? new HashMap<String, Object>() : new HashMap(cv.getConstraintDescriptor().getAttributes());
        this.putAdditionalParamsToParamMap(cv);
    }

    public ConstraintViolationBean(String message, String propertyPath, String validatorClass, String rootClassName) {
        this.message = message;
        this.propertyPath = propertyPath;
        this.validatorClass = validatorClass;
        this.rootClassName = rootClassName;
        this.messageTemplate = validatorClass + ".message";
        this.paramMap = new HashMap<String, Object>();
        this.annotationDescriptionString = "";
    }

    private void putAdditionalParamsToParamMap(ConstraintViolation<?> cv) {
        this.paramMap.put("leafClassName", this.getLeafClassName());
        this.paramMap.put("invalidValue", this.getInvalidValue());
        this.paramMap.put("annotation", this.getAnnotation());
        if (this.getAnnotation().startsWith("jp.ecuacion.lib.core.jakartavalidation.validator.Conditional")) {
            String conditionValueKind;
            String valuesOfConditionFieldToValidate = null;
            if (((Boolean)this.paramMap.get("conditionValueIsEmpty")).booleanValue()) {
                conditionValueKind = "conditionValueIsEmpty";
            } else if (((Boolean)this.paramMap.get("conditionValueIsNotEmpty")).booleanValue()) {
                conditionValueKind = "conditionValueIsNotEmpty";
            } else if (!((String)this.paramMap.get("fieldHoldingConditionValue")).equals("[null]")) {
                conditionValueKind = "fieldHoldingConditionValue";
                valuesOfConditionFieldToValidate = (String)ConstraintViolationBean.getFieldValue(conditionValueKind, this.getInstance(), conditionValueKind);
            } else {
                conditionValueKind = "conditionValue";
                String[] strs = (String[])this.paramMap.get(conditionValueKind);
                StringBuilder csv = new StringBuilder();
                boolean is1st = true;
                for (String str : strs) {
                    if (is1st) {
                        is1st = false;
                    } else {
                        csv.append(", ");
                    }
                    csv.append(str);
                }
                valuesOfConditionFieldToValidate = csv.toString();
            }
            this.paramMap.put("conditionValueKind", conditionValueKind);
            this.paramMap.put("valuesOfConditionFieldToValidate", valuesOfConditionFieldToValidate);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getValidatorClass() {
        return this.validatorClass;
    }

    public String getAnnotationDescriptionString() {
        return this.annotationDescriptionString;
    }

    public String getAnnotation() {
        return this.cv.getConstraintDescriptor().getAnnotation().annotationType().getCanonicalName();
    }

    public Map<String, Object> getAnnotationAttributes() {
        return this.cv.getConstraintDescriptor().getAttributes();
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public String getLeafClassName() {
        return this.cv.getLeafBean().getClass().getName();
    }

    public String getInvalidValue() {
        return this.cv.getInvalidValue() == null ? "null" : this.cv.getInvalidValue().toString();
    }

    @Nonnull
    public String getMessageId() {
        return this.getAnnotation();
    }

    public Object getInstance() {
        return this.cv.getLeafBean();
    }

    @Nonnull
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }
}

