/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.BeanValidationAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class BeanValidationUtil {
    private boolean isMessageWithItemName;
    private PropertyFileUtil.Arg messagePrefix;
    private PropertyFileUtil.Arg messagePostfix;

    public <T> void validateThenThrow(@RequireNonnull T object) throws MultipleAppException {
        MultipleAppException exList = this.validateThenReturn(object);
        if (exList != null && exList.getList().size() > 0) {
            throw exList;
        }
    }

    @Nullable
    public <T> MultipleAppException validateThenReturn(@RequireNonnull T object) {
        Set<ConstraintViolation<T>> set = this.validate(object);
        MultipleAppException exList = null;
        if (set != null && set.size() > 0) {
            ArrayList<BeanValidationAppException> list = new ArrayList<BeanValidationAppException>();
            for (ConstraintViolation<T> v : set) {
                BeanValidationAppException bvex = new BeanValidationAppException(v).setMessageWithItemName(this.isMessageWithItemName);
                if (this.messagePrefix != null) {
                    bvex.setMessagePrefix(this.messagePrefix);
                }
                if (this.messagePostfix != null) {
                    bvex.setMessagePostfix(this.messagePostfix);
                }
                list.add(bvex);
            }
            exList = new MultipleAppException(list);
        } else {
            exList = null;
        }
        return exList;
    }

    @Nonnull
    public <T> Set<ConstraintViolation<T>> validate(@RequireNonnull T object) {
        ObjectsUtil.paramRequireNonNull(object);
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        return validator.validate(object, new Class[0]);
    }

    public BeanValidationUtil setMessageWithItemName(boolean isMessageWithItemName) {
        this.isMessageWithItemName = isMessageWithItemName;
        return this;
    }

    public BeanValidationUtil setMessagePrefix(PropertyFileUtil.Arg messagePrefix) {
        this.messagePrefix = messagePrefix;
        return this;
    }

    public BeanValidationUtil setMessagePostfix(PropertyFileUtil.Arg messagePostfix) {
        this.messagePostfix = messagePostfix;
        return this;
    }
}

