/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.beanvalidation.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.ecuacion.lib.core.beanvalidation.validator.PatternWithDescription;

public class PatternWithDescriptionValidator
implements ConstraintValidator<PatternWithDescription, String> {
    private String regExp;

    public void initialize(PatternWithDescription constraintAnnotation) {
        this.regExp = constraintAnnotation.regexp();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Objects.requireNonNull(value);
        Matcher m = Pattern.compile(this.regExp).matcher(value);
        return m.matches();
    }
}

