/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.beanvalidation.bean;

import jakarta.annotation.Nonnull;
import jakarta.validation.ConstraintViolation;
import java.util.HashMap;
import java.util.Map;

public class BeanValidationErrorInfoBean {
    private String message;
    private String propertyPath;
    private String validatorClass;
    private String annotationDescriptionString;
    private String annotation;
    private Map<String, Object> annotationAttributes;
    private String messageTemplate;
    private String rootClassName;
    private String leafClassName;
    private String invalidValue;
    private Object instance;
    @Nonnull
    private Map<String, Object> paramMap;

    public BeanValidationErrorInfoBean(ConstraintViolation<?> cv) {
        this.message = cv.getMessage();
        this.propertyPath = cv.getPropertyPath().toString();
        this.validatorClass = cv.getConstraintDescriptor().getAnnotation().annotationType().getName();
        this.annotationDescriptionString = cv.getConstraintDescriptor().getAnnotation().toString();
        this.annotation = cv.getConstraintDescriptor().getAnnotation().annotationType().getCanonicalName();
        this.annotationAttributes = cv.getConstraintDescriptor().getAttributes();
        this.messageTemplate = cv.getMessageTemplate();
        if (this.messageTemplate.startsWith("{")) {
            this.messageTemplate = this.messageTemplate.replace("{", "").replace("}", "");
        }
        this.rootClassName = cv.getRootBeanClass().getName();
        this.leafClassName = cv.getLeafBean().getClass().getName();
        this.invalidValue = cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString();
        this.instance = cv.getLeafBean();
        this.paramMap = cv.getConstraintDescriptor().getAttributes() == null ? new HashMap() : cv.getConstraintDescriptor().getAttributes();
    }

    public BeanValidationErrorInfoBean(String message, String propertyPath, String validatorClass, String rootClassName) {
        this.message = message;
        this.propertyPath = propertyPath;
        this.validatorClass = validatorClass;
        this.rootClassName = rootClassName;
        this.messageTemplate = validatorClass + ".message";
        this.paramMap = new HashMap<String, Object>();
        this.annotationDescriptionString = "";
    }

    public String getMessage() {
        return this.message;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getValidatorClass() {
        return this.validatorClass;
    }

    public String getAnnotationDescriptionString() {
        return this.annotationDescriptionString;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public Map<String, Object> getAnnotationAttributes() {
        return this.annotationAttributes;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public String getLeafClassName() {
        return this.leafClassName;
    }

    public String getInvalidValue() {
        return this.invalidValue;
    }

    @Nonnull
    public String getMessageId() {
        return this.annotation;
    }

    public Object getInstance() {
        return this.instance;
    }

    @Nonnull
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }
}

