/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilFileKindEnum;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilValueGetter;

public class PropertyFileUtil {
    private static Map<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter> getterMap = new HashMap<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter>();

    private PropertyFileUtil() {
    }

    @Nonnull
    public static String getApp(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APP).getProp(key);
    }

    public static boolean hasApp(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APP).hasProp(key);
    }

    @Nonnull
    public static String getApplication(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APP).getProp(key);
    }

    public static boolean hasApplication(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APP).hasProp(key);
    }

    @Nonnull
    public static String getMsg(@RequireNonnull String key, String ... args) {
        return PropertyFileUtil.getMessage(key, args);
    }

    @Nonnull
    public static String getMsg(@Nullable Locale locale, @RequireNonnull String key, String ... args) {
        return PropertyFileUtil.getMessage(locale, key, args);
    }

    @Nonnull
    public static String getMsg(@RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMessage(key, args);
    }

    @Nonnull
    public static String getMsg(@Nullable Locale locale, @RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMessage(locale, key, args);
    }

    public static boolean hasMsg(@RequireNonnull String key) {
        return PropertyFileUtil.hasMessage(key);
    }

    @Nonnull
    public static String getMessage(@RequireNonnull String key, String ... args) {
        return PropertyFileUtil.getMessage(null, key, args);
    }

    @Nonnull
    public static String getMessage(@Nullable Locale locale, @RequireNonnull String key, String ... args) {
        String msgStr = getterMap.get((Object)PropertyFileUtilFileKindEnum.MSG).getProp(locale, key);
        return args.length == 0 ? msgStr : MessageFormat.format(msgStr, args);
    }

    @Nonnull
    public static String getMessage(@RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMsg(null, key, args);
    }

    @Nonnull
    public static String getMessage(@Nullable Locale locale, @RequireNonnull String key, @RequireNonnull Arg[] args) {
        ArrayList list = new ArrayList();
        Arrays.asList(args).stream().forEach(arg -> list.add(arg.isMessageId() ? PropertyFileUtil.getMsg(arg.getArgString(), arg.messageArgs) : arg.getArgString()));
        return PropertyFileUtil.getMessage(locale, key, list.toArray(new String[list.size()]));
    }

    public static boolean hasMessage(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.MSG).hasProp(key);
    }

    @Nonnull
    public static String getItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAME).getProp(null, key);
    }

    @Nonnull
    public static String getItemName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAME).getProp(locale, key);
    }

    public static boolean hasItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAME).hasProp(key);
    }

    @Nonnull
    public static String getEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAME).getProp(null, key);
    }

    @Nonnull
    public static String getEnumName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAME).getProp(locale, key);
    }

    public static boolean hasEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAME).hasProp(key);
    }

    @Nonnull
    public static String getValidationMessage(@RequireNonnull String key, Map<String, String> argMap) {
        return PropertyFileUtil.getValidationMessage(null, key, argMap);
    }

    @Nonnull
    public static String getValidationMessage(@Nullable Locale locale, @RequireNonnull String key, Map<String, String> argMap) {
        String message = getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES).getProp(locale, key);
        return PropertyFileUtil.substituteArgsToValidationMessages(message, argMap);
    }

    @Nonnull
    public static String getValidationMessageWithItemName(@RequireNonnull String key, Map<String, String> argMap) {
        return PropertyFileUtil.getValidationMessageWithItemName(null, key, argMap);
    }

    @Nonnull
    public static String getValidationMessageWithItemName(@Nullable Locale locale, @RequireNonnull String key, Map<String, String> argMap) {
        String message = getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES_WITH_ITEM_NAMES).getProp(locale, key);
        return PropertyFileUtil.substituteArgsToValidationMessages(message, argMap);
    }

    private static String substituteArgsToValidationMessages(String message, Map<String, String> argMap) {
        String rtnMessage = message;
        for (Map.Entry<String, String> entry : argMap.entrySet()) {
            rtnMessage = rtnMessage.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return rtnMessage;
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(propertyUtilFileKind)).getProp(null, key);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(propertyUtilFileKind)).getProp(locale, key);
    }

    public static boolean has(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(propertyUtilFileKind)).hasProp(key);
    }

    public static void addResourceBundlePostfix(String postfix) {
        PropertyFileUtilValueGetter.addToDynamicPostfixList(postfix);
    }

    static {
        for (PropertyFileUtilFileKindEnum anEnum : PropertyFileUtilFileKindEnum.values()) {
            getterMap.put(anEnum, new PropertyFileUtilValueGetter(anEnum));
        }
    }

    public static class Arg {
        private boolean isMessageId;
        private String argString;
        private Arg[] messageArgs;

        public static Arg string(String argString) {
            return new Arg(false, argString, new Arg[0]);
        }

        public static Arg[] strings(String ... argStrings) {
            return Arrays.asList(argStrings).stream().map(arg -> Arg.string(arg)).toList().toArray(new Arg[argStrings.length]);
        }

        public static Arg message(String messageId, Arg ... messageArgs) {
            return new Arg(true, messageId, messageArgs);
        }

        private Arg(boolean isMessageId, String argString, Arg ... messageArgs) {
            this.isMessageId = isMessageId;
            this.argString = argString;
            this.messageArgs = messageArgs;
        }

        public String getArgString() {
            return this.argString;
        }

        public boolean isMessageId() {
            return this.isMessageId;
        }

        public Arg[] getMessageArgs() {
            return this.messageArgs;
        }
    }
}

