/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeSystemException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilFileKindEnum;
import org.apache.commons.lang3.tuple.Pair;

public class PropertyFileUtilValueGetter {
    private String[][] filePrefixes;
    private static final String[] LIB_MODULES = new String[]{"core", "jpa"};
    private static final String[] SPLIB_MODULES = new String[]{"web"};
    private static final String[] UTIL_MODULES = new String[]{"jpa", "poi"};
    private static final String[] APP_MODULES = new String[]{"", "base", "core", "core_web", "core_batch"};
    private static final String[] APP_ENVS = new String[]{"", "profile"};
    private static final List<String> dynamicPostfixList = new ArrayList<String>();
    public static final ThreadLocal<String> bundleNameForModule = new ThreadLocal();
    public static final ThreadLocal<Locale> specifiedLocale = new ThreadLocal();

    public static void addToDynamicPostfixList(String postfix) {
        if (!dynamicPostfixList.contains(postfix)) {
            dynamicPostfixList.add(postfix);
        }
    }

    static List<String> getDynamicPostfixList() {
        return new ArrayList<String>(dynamicPostfixList);
    }

    public PropertyFileUtilValueGetter(@RequireNonnull PropertyFileUtilFileKindEnum fileKindEnum) {
        this.filePrefixes = ObjectsUtil.paramRequireNonNull(fileKindEnum).getActualFilePrefixes();
    }

    PropertyFileUtilValueGetter(@RequireNonnull String[][] filePrefixes) {
        this.filePrefixes = Objects.requireNonNull(filePrefixes);
    }

    List<String> getPostfixes() {
        ArrayList<String> rtnList = new ArrayList<String>();
        rtnList.addAll(Arrays.asList(LIB_MODULES).stream().map(str -> "lib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(SPLIB_MODULES).stream().map(str -> "splib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(UTIL_MODULES).stream().map(str -> "util_" + str).toList());
        rtnList.addAll(dynamicPostfixList);
        for (String systemModuleName : APP_MODULES) {
            for (String envName : APP_ENVS) {
                boolean needsUs = !systemModuleName.equals("") && !envName.equals("");
                rtnList.add(systemModuleName + (needsUs ? "_" : "") + envName);
            }
        }
        return rtnList;
    }

    @Nonnull
    private String getValue(@Nullable Locale locale, @RequireNonnull String key) {
        ObjectsUtil.paramRequireNonNull(key);
        String value = null;
        value = System.getProperties().keySet().contains(key) ? System.getProperties().getProperty(key) : this.getValueFromPropertiesFiles(locale, key);
        List<Pair<PropertyFileUtilFileKindEnum, String>> list = this.analyze(value);
        StringBuilder sb = new StringBuilder();
        for (Pair<PropertyFileUtilFileKindEnum, String> tuple : list) {
            if (tuple.getLeft() == null) {
                sb.append((String)tuple.getRight());
                continue;
            }
            sb.append(PropertyFileUtil.get(((PropertyFileUtilFileKindEnum)((Object)tuple.getLeft())).getFilePrefix(), (String)tuple.getRight()));
        }
        return sb.toString();
    }

    private String getValueFromPropertiesFiles(Locale locale, String key) {
        for (String[] filePrefixesOfSamePriority : this.filePrefixes) {
            String value = this.getValueFromPropertiesFilesWithSamePriority(locale, key, filePrefixesOfSamePriority);
            if (value == null) continue;
            return value;
        }
        throw new RuntimeSystemException("No key in .properties. key: " + key);
    }

    private String getValueFromPropertiesFilesWithSamePriority(Locale locale, String key, String[] filePrefixesOfSamePriority) {
        List<String> postfixes = this.getPostfixes();
        HashMap<String, ResourceBundle> rbMap = new HashMap<String, ResourceBundle>();
        for (String prefix : filePrefixesOfSamePriority) {
            for (int i = 0; i < postfixes.size(); ++i) {
                String postfix = postfixes.get(i);
                String filename = prefix + (postfix.equals("") ? "" : "_") + postfix;
                ResourceBundle bundle = this.getResourceBundle(filename, locale);
                rbMap.put(filename, bundle);
            }
        }
        String valueNonDefault = this.getValueAndDuplicationCheck(rbMap, key);
        String valueDefault = this.getValueAndDuplicationCheck(rbMap, key + ".default");
        return valueNonDefault == null ? valueDefault : valueNonDefault;
    }

    @Nonnull
    private ResourceBundle getResourceBundle(@RequireNonnull String bundleId, @Nullable Locale locale) {
        ObjectsUtil.paramRequireNonNull(bundleId);
        if (locale == null) {
            locale = Locale.ROOT;
        }
        try {
            bundleNameForModule.set(bundleId);
            specifiedLocale.set(locale);
            String bundle = "jp.ecuacion.lib.core." + new StringUtil().getUpperCamelFromSnakeOrNullIfInputIsNull(bundleId.replaceAll("-", "_"));
            return ResourceBundle.getBundle(bundle, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return ResourceBundle.getBundle(bundleId, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            }
            catch (UnsupportedOperationException | MissingResourceException runtimeException) {
                return null;
            }
        }
    }

    private String getValueAndDuplicationCheck(Map<String, ResourceBundle> resourceBundleMap, String key) {
        String messageString = null;
        for (Map.Entry<String, ResourceBundle> entry : resourceBundleMap.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().containsKey(key)) continue;
            if (messageString != null) {
                throw new RuntimeSystemException("Key '" + key + "' in properties file duplicated. ");
            }
            messageString = entry.getValue().getString(key);
        }
        return messageString;
    }

    private List<Pair<PropertyFileUtilFileKindEnum, String>> analyze(String string) {
        String startBracket = "{";
        String endBracket = "}";
        ArrayList<Pair<PropertyFileUtilFileKindEnum, String>> list = new ArrayList<Pair<PropertyFileUtilFileKindEnum, String>>();
        String stringLeft = string;
        while (true) {
            int indexOfStartBracket = stringLeft.indexOf("{");
            int indexOfEndBracket = stringLeft.indexOf("}");
            if (indexOfStartBracket == -1) break;
            if (indexOfStartBracket > indexOfEndBracket) {
                throw new RuntimeSystemException("startBracketFollowsEndBracket. the brackets in the string is somehow wrong. string: " + stringLeft);
            }
            list.add((Pair<PropertyFileUtilFileKindEnum, String>)Pair.of(null, (Object)stringLeft.substring(0, indexOfStartBracket)));
            String stringInBrackets = stringLeft.substring(indexOfStartBracket + "{".length(), indexOfEndBracket);
            PropertyFileUtilFileKindEnum fileKind = this.getFileKindFromStringInBrackets(stringInBrackets);
            if (fileKind == null) {
                list.add((Pair<PropertyFileUtilFileKindEnum, String>)Pair.of(null, (Object)stringLeft.substring(indexOfStartBracket, indexOfEndBracket + "}".length())));
            } else {
                list.add((Pair<PropertyFileUtilFileKindEnum, String>)Pair.of((Object)((Object)fileKind), (Object)stringInBrackets.split(":")[1]));
            }
            stringLeft = stringLeft.substring(indexOfEndBracket + "}".length());
        }
        list.add(Pair.of(null, (Object)stringLeft));
        return list;
    }

    private PropertyFileUtilFileKindEnum getFileKindFromStringInBrackets(String stringInBrackets) {
        if (!stringInBrackets.contains(":")) {
            return null;
        }
        return PropertyFileUtilFileKindEnum.getEnumFromFilePrefix(stringInBrackets.split(":")[0]);
    }

    public boolean hasProp(String key) {
        Objects.requireNonNull(key);
        try {
            this.getValue(null, key);
            return true;
        }
        catch (RuntimeSystemException ex) {
            return false;
        }
    }

    public String getProp(String key) {
        return this.getProp(null, key);
    }

    @Nonnull
    public String getProp(@Nullable Locale locale, @RequireNonnull String key) {
        ObjectsUtil.paramRequireNonNull(key);
        if (key.equals("")) {
            throw new RuntimeSystemException("Message ID is blank.");
        }
        return this.getValue(locale, key);
    }
}

