/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.RuntimeExceptionWithMessageId;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public class EnumUtil {
    @Nonnull
    public static <T> T getEnumFromCode(@Nonnull Class<T> enumClass, @RequireNonnull String code) {
        return ObjectsUtil.returnRequireNonNull(EnumUtil.getEnumFromCodeOrNullIfCodeIsNull(enumClass, ObjectsUtil.paramRequireNonNull(code)));
    }

    @Nullable
    public static <T> T getEnumFromCodeOrNullIfCodeIsNull(@Nonnull Class<T> enumClass, @Nullable String code) {
        ObjectsUtil.paramRequireNonNull(enumClass);
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException();
        }
        if (code == null) {
            return null;
        }
        for (EnumValueInfo enumValue : EnumUtil.getEnumInfo(enumClass).valueList) {
            if (!enumValue.getCode().equals(code)) continue;
            return enumValue.getInstance();
        }
        throw new RuntimeExceptionWithMessageId("jp.ecuacion.lib.core.EnumNotExist.message", enumClass.getSimpleName(), "code", code);
    }

    public static <T> boolean hasEnumFromCode(@Nonnull Class<T> enumClass, @Nonnull String code) {
        ObjectsUtil.paramRequireNonNull(code);
        try {
            T anEnum = EnumUtil.getEnumFromCodeOrNullIfCodeIsNull(enumClass, code);
            return anEnum != null;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    @Nonnull
    public <T> List<String[]> getListForHtmlSelect(@Nonnull Class<T> enumClass, @Nullable Locale locale, @Nullable String optionsString) {
        optionsString = optionsString == null ? "" : optionsString;
        String[] options = optionsString.split(",");
        EnumClassInfo<T> enumInfo = EnumUtil.getEnumInfo(enumClass);
        HashMap<String, String> optionMap = new HashMap<String, String>();
        for (String option : options) {
            String optionValue;
            String optionKey = option.split("=")[0];
            String string = optionValue = option.split("=").length == 1 ? null : option.split("=")[1];
            if (!ListForHtmlSelectOptionEnum.getNameSet().contains(optionKey)) continue;
            optionMap.put(optionKey, optionValue);
        }
        ArrayList<String[]> rtnList = new ArrayList<String[]>();
        if (optionMap.keySet().size() > 1) {
            throw new RuntimeException("Multiple options cannot be set. (" + optionMap.keySet().toString() + ")");
        }
        if (optionMap.keySet().size() == 0) {
            enumInfo.getValueList().stream().forEach(value -> rtnList.add(new String[]{value.getCode(), value.getLabel()}));
            return rtnList;
        }
        String optionKey = (String)optionMap.keySet().stream().toList().get(0);
        String optionValue = (String)optionMap.get(optionKey);
        for (EnumValueInfo<T> value2 : enumInfo.getValueList()) {
            if (!(optionKey.equals("including") && Arrays.asList(optionValue.split("\\|")).contains(value2.getName()) || optionKey.equals("excluding") && !Arrays.asList(optionValue.split("\\|")).contains(value2.getName()) || optionKey.equals("firstCharOfCodeEqualTo") && Arrays.asList(optionValue.split("\\|")).contains(value2.getCode().substring(0, 1)) || optionKey.equals("firstCharOfCodeLessThanOrEqualTo") && value2.getCode().substring(0, 1).getBytes(StandardCharsets.US_ASCII)[0] <= optionValue.getBytes(StandardCharsets.US_ASCII)[0]) && (!optionKey.equals("firstCharOfCodeGreaterThanOrEqualTo") || value2.getCode().substring(0, 1).getBytes(StandardCharsets.US_ASCII)[0] < optionValue.getBytes(StandardCharsets.US_ASCII)[0])) continue;
            rtnList.add(new String[]{value2.getCode(), value2.getLabel()});
        }
        return rtnList;
    }

    public static <T> EnumClassInfo<T> getEnumInfo(Class<T> enumClass) {
        return EnumUtil.getEnumInfo(enumClass, Locale.getDefault());
    }

    public static <T> EnumClassInfo<T> getEnumInfo(Class<T> enumClass, Locale locale) {
        ArrayList valueList = new ArrayList();
        String enumClassName = enumClass.getSimpleName();
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException();
        }
        for (T enumValue : enumClass.getEnumConstants()) {
            String name = enumValue.toString();
            try {
                Method codeMethod = enumClass.getMethod("getCode", null);
                String code = (String)codeMethod.invoke(enumValue, (Object[])null);
                Method displayNameMethod = enumClass.getMethod("getDisplayName", Locale.class);
                String displayName = (String)displayNameMethod.invoke(enumValue, locale);
                valueList.add(new EnumValueInfo<T>(name, code, displayName, enumValue, enumClassName));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return new EnumClassInfo(enumClass.getSimpleName(), valueList);
    }

    public static class EnumClassInfo<T> {
        private String enumClassName;
        private List<EnumValueInfo<T>> valueList;

        public EnumClassInfo(String enumClassName, List<EnumValueInfo<T>> valueList) {
            this.enumClassName = enumClassName;
            this.valueList = valueList;
        }

        public String getEnumClassName() {
            return this.enumClassName;
        }

        public List<EnumValueInfo<T>> getValueList() {
            return this.valueList;
        }
    }

    public static class EnumValueInfo<T> {
        private String name;
        private String code;
        private String displayName;
        private T instance;
        private String enumClassName;

        public EnumValueInfo(String name, String code, String label, T instance, String enumClassName) {
            this.name = name;
            this.code = code;
            this.displayName = label;
            this.instance = instance;
            this.enumClassName = enumClassName;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.displayName;
        }

        public T getInstance() {
            return this.instance;
        }

        public String getEnumClassName() {
            return this.enumClassName;
        }
    }

    private static enum ListForHtmlSelectOptionEnum {
        including,
        excluding,
        firstCharOfCodeEqualTo,
        firstCharOfCodeLessThanOrEqualTo,
        firstCharOfCodeGreaterThanOrEqualTo;


        public static Set<String> getNameSet() {
            HashSet<String> rtnSet = new HashSet<String>();
            for (ListForHtmlSelectOptionEnum anEnum : ListForHtmlSelectOptionEnum.values()) {
                rtnSet.add(anEnum.name());
            }
            return rtnSet;
        }
    }
}

