/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.beanvalidation.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jp.ecuacion.lib.core.beanvalidation.validator.EnumElement;

public class EnumElementValidator
implements ConstraintValidator<EnumElement, String> {
    private String enumPackage;
    private String enumClass;

    public void initialize(EnumElement constraintAnnotation) {
        this.enumPackage = constraintAnnotation.enumPackage();
        this.enumClass = constraintAnnotation.enumClass();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        String classFullName = this.enumPackage + "." + this.enumClass;
        try {
            ?[] objs;
            Class<?> cls = Class.forName(classFullName);
            if (!cls.isEnum()) {
                throw new RuntimeException("A class is found. An enum is supposed to be found: " + classFullName);
            }
            for (Object obj : objs = cls.getEnumConstants()) {
                if (!obj.toString().equals(value)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

