/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.ConstraintViolationBeanException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.jakartavalidation.bean.ConstraintViolationBean;
import jp.ecuacion.lib.core.util.PropertyFileUtil;

public class ValidationUtil {
    private ValidationUtil() {
    }

    @Nonnull
    public static <T> Set<ConstraintViolationBean<T>> validate(@RequireNonnull T object) {
        return ValidationUtil.validate(object, new Class[0]);
    }

    @Nonnull
    public static <T> Set<ConstraintViolationBean<T>> validate(@RequireNonnull T object, Class<?> ... groups) {
        return ValidationUtil.validate(object, null, groups);
    }

    @Nonnull
    public static <T> Set<ConstraintViolationBean<T>> validate(@RequireNonnull T object, @Nullable MessageParameterBean parameterBean) {
        return ValidationUtil.validate(object, parameterBean, new Class[0]);
    }

    @Nonnull
    public static <T> Set<ConstraintViolationBean<T>> validate(@RequireNonnull T object, @Nullable MessageParameterBean parameterBean, Class<?> ... groups) {
        Validator v = Validation.buildDefaultValidatorFactory().getValidator();
        Set set = groups == null || groups.length == 0 ? v.validate(object, new Class[0]) : v.validate(object, (Class[])groups);
        MessageParameterBean param = parameterBean == null ? new MessageParameterBean() : parameterBean;
        List<ConstraintViolationBean> list = set.stream().map(cv -> new ConstraintViolationBean(cv)).peek(cv -> cv.setMessageWithItemName(param.isMessageWithItemNames)).peek(cv -> cv.setMessagePrefix(param.getMessagePrefix())).peek(cv -> cv.setMessagePostfix(param.getMessagePostfix())).toList();
        return new HashSet<ConstraintViolationBean<T>>(list);
    }

    public static <T> void validateThenThrow(@RequireNonnull T object) throws ConstraintViolationBeanException {
        ValidationUtil.validateThenThrow(object, (Class[])null);
    }

    public static <T> void validateThenThrow(@RequireNonnull T object, Class<?> ... groups) throws ConstraintViolationBeanException {
        ValidationUtil.validateThenThrow(object, null, null, null, groups);
    }

    @Deprecated(since="14.26.0")
    public static <T> void validateThenThrow(@RequireNonnull T object, @Nullable Boolean addsItemNameToMessage, @Nullable PropertyFileUtil.Arg messagePrefix, @Nullable PropertyFileUtil.Arg messagePostfix) throws ConstraintViolationBeanException {
        ValidationUtil.validateThenThrow(object, addsItemNameToMessage, messagePrefix, messagePostfix, (Class[])null);
    }

    public static <T> void validateThenThrow(@RequireNonnull T object, @Nullable MessageParameterBean parameterBean) throws ConstraintViolationBeanException {
        ValidationUtil.validateThenThrow(object, parameterBean, (Class[])null);
    }

    @Deprecated(since="14.26.0")
    public static <T> void validateThenThrow(@RequireNonnull T object, @Nullable Boolean addsItemNameToMessage, @Nullable PropertyFileUtil.Arg messagePrefix, @Nullable PropertyFileUtil.Arg messagePostfix, Class<?> ... groups) throws ConstraintViolationBeanException {
        Set<ConstraintViolationBean<T>> set = ValidationUtil.validate(object, new MessageParameterBean(addsItemNameToMessage == null ? Boolean.FALSE : addsItemNameToMessage, messagePrefix, messagePostfix), groups);
        if (set.size() > 0) {
            throw new ConstraintViolationBeanException(set);
        }
    }

    public static <T> void validateThenThrow(@RequireNonnull T object, @Nullable MessageParameterBean parameterBean, Class<?> ... groups) throws ConstraintViolationBeanException {
        Set<ConstraintViolationBean<T>> set = ValidationUtil.validate(object, parameterBean, groups);
        if (set.size() > 0) {
            throw new ConstraintViolationBeanException(set);
        }
    }

    @Nonnull
    @Deprecated(since="14.26.0")
    public static <T> Optional<MultipleAppException> validateThenReturn(@RequireNonnull T object) {
        return ValidationUtil.validateThenReturn(object, false, null, null, (Class[])null);
    }

    @Nonnull
    @Deprecated(since="14.26.0")
    public static <T> Optional<MultipleAppException> validateThenReturn(@RequireNonnull T object, Class<?> ... groups) {
        return ValidationUtil.validateThenReturn(object, false, null, null, groups);
    }

    @Nonnull
    @Deprecated(since="14.26.0")
    public static <T> Optional<MultipleAppException> validateThenReturn(@RequireNonnull T object, @Nullable Boolean addsItemNameToMessage, @Nullable PropertyFileUtil.Arg messagePrefix, @Nullable PropertyFileUtil.Arg messagePostfix) {
        return ValidationUtil.validateThenReturn(object, addsItemNameToMessage, messagePrefix, messagePostfix, (Class[])null);
    }

    @Nonnull
    @Deprecated(since="14.26.0")
    public static <T> Optional<MultipleAppException> validateThenReturn(@RequireNonnull T object, Boolean addsItemNameToMessage, @Nullable PropertyFileUtil.Arg messagePrefix, @Nullable PropertyFileUtil.Arg messagePostfix, Class<?> ... groups) {
        Set<ConstraintViolationBean<T>> set = ValidationUtil.validate(object, new MessageParameterBean().isMessageWithItemNames(addsItemNameToMessage == null ? Boolean.FALSE : addsItemNameToMessage).messagePrefix(messagePrefix).messagePostfix(messagePostfix), groups);
        if (set.size() == 0) {
            return Optional.empty();
        }
        MultipleAppException listEx = new MultipleAppException(set.stream().map(bean -> new ValidationAppException(bean)).toList());
        return Optional.of(listEx);
    }

    public static MessageParameterBean messageParameters() {
        return new MessageParameterBean();
    }

    public static class MessageParameterBean {
        private Boolean isMessageWithItemNames;
        private PropertyFileUtil.Arg messagePrefix;
        private PropertyFileUtil.Arg messagePostfix;

        MessageParameterBean() {
        }

        MessageParameterBean(Boolean isMessageWithItemNames, PropertyFileUtil.Arg messagePrefix, PropertyFileUtil.Arg messagePostfix) {
            this.isMessageWithItemNames = isMessageWithItemNames;
            this.messagePrefix = messagePrefix;
            this.messagePostfix = messagePostfix;
        }

        public Boolean isMessageWithItemNames() {
            return this.isMessageWithItemNames;
        }

        public MessageParameterBean isMessageWithItemNames(Boolean isMessageWithItemNames) {
            this.isMessageWithItemNames = isMessageWithItemNames;
            return this;
        }

        public PropertyFileUtil.Arg getMessagePrefix() {
            return this.messagePrefix;
        }

        public MessageParameterBean messagePrefix(PropertyFileUtil.Arg messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        public MessageParameterBean messagePrefix(String messagePrefix) {
            this.messagePrefix = PropertyFileUtil.Arg.string(messagePrefix);
            return this;
        }

        public PropertyFileUtil.Arg getMessagePostfix() {
            return this.messagePostfix;
        }

        public MessageParameterBean messagePostfix(String messagePostfix) {
            this.messagePostfix = PropertyFileUtil.Arg.string(messagePostfix);
            return this;
        }

        public MessageParameterBean messagePostfix(PropertyFileUtil.Arg messagePostfix) {
            this.messagePostfix = messagePostfix;
            return this;
        }
    }
}

