/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.logging.internal;

import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class EclibLogger {
    protected Logger internalLogger;

    public EclibLogger(String loggerName) {
        this.internalLogger = LoggerFactory.getLogger((String)loggerName);
    }

    public EclibLogger(Class<?> cls) {
        this.internalLogger = LoggerFactory.getLogger((String)cls.getName());
    }

    public void log(Level logLevel, String message) {
        ObjectsUtil.requireNonNull(message);
        ObjectsUtil.requireNonNull(logLevel);
        switch (logLevel) {
            case ERROR: {
                this.internalLogger.error(message);
                break;
            }
            case WARN: {
                this.internalLogger.warn(message);
                break;
            }
            case INFO: {
                this.internalLogger.info(message);
                break;
            }
            case DEBUG: {
                this.internalLogger.debug(message);
                break;
            }
            case TRACE: {
                this.internalLogger.trace(message);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(logLevel));
            }
        }
    }
}

