/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.item;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.item.Item;
import jp.ecuacion.lib.core.jakartavalidation.annotation.ItemNameKeyClass;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.ReflectionUtil;
import org.apache.commons.lang3.StringUtils;

public interface ItemContainer {
    @Nullable
    public Item[] customizedItems();

    @Nonnull
    default public Item getNewItem(@RequireNonempty String itemPropertyPath) {
        return new Item(ObjectsUtil.requireNonEmpty(itemPropertyPath));
    }

    @Nonnull
    default public Item getItem(@RequireNonempty String itemPropertyPath) {
        Map<String, Item> map = Arrays.asList(this.customizedItems() == null ? new Item[]{} : this.customizedItems()).stream().collect(Collectors.toMap(e -> e.getItemPropertyPath(), e -> e));
        Item item = map.get(ObjectsUtil.requireNonEmpty(itemPropertyPath));
        item = item == null ? this.getNewItem(itemPropertyPath) : item;
        Optional<ItemNameKeyClass> optAn = ReflectionUtil.searchAnnotationPlacedAtClass(this.getClass(), ItemNameKeyClass.class);
        if (optAn.isPresent()) {
            item.setItemNameKeyClassFromAnnotation(StringUtils.uncapitalize((String)optAn.get().value()));
        }
        item.setItemNameKeyClassFromClassName(StringUtils.uncapitalize((String)this.getClass().getSimpleName()));
        return item;
    }

    @Nonnull
    default public Item[] mergeItems(@Nullable Item[] items1, @Nullable Item[] items2) {
        items1 = items1 == null ? new Item[]{} : items1;
        items2 = items2 == null ? new Item[]{} : items2;
        ArrayList<Item> list = new ArrayList<Item>(Arrays.asList(items1));
        List<String> propertyPath1List = Arrays.asList(items1).stream().map(e -> e.getItemPropertyPath()).toList();
        for (String propertyPath2 : Arrays.asList(items2).stream().map(e -> e.getItemPropertyPath()).toList()) {
            if (!propertyPath1List.contains(propertyPath2)) continue;
            throw new RuntimeException("'itemPropertyPath' of EclibItem[] duplicated in Items. key: " + propertyPath2);
        }
        list.addAll(Arrays.asList(items2));
        return list.toArray(new Item[list.size()]);
    }
}

