/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.logging;

import jakarta.annotation.Nullable;
import java.util.Locale;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.logging.internal.EclibLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.slf4j.event.Level;

public class ErrorLogger
extends EclibLogger {
    public ErrorLogger() {
        super("error-logger");
    }

    public void info(@RequireNonnull String message) {
        this.log(Level.INFO, message);
    }

    public void warn(@RequireNonnull String message) {
        this.log(Level.WARN, message);
    }

    public void error(@RequireNonnull String message) {
        this.log(Level.ERROR, message);
    }

    public void logSystemError(@RequireNonnull Throwable throwable) {
        this.logSystemError(throwable, null);
    }

    public void logSystemError(@RequireNonnull Throwable throwable, @Nullable String additionalMessage) {
        Object msg;
        ObjectsUtil.requireNonNull(throwable);
        Object object = msg = throwable.getMessage() == null ? "" : " - " + ExceptionUtil.getMessageList(throwable, Locale.ENGLISH).toString().replace("\n", " ");
        if (throwable instanceof ValidationAppException) {
            msg = (String)msg + "\n" + ((ValidationAppException)throwable).getConstraintViolationBean().toString();
        }
        this.internalLogger.error("A system error has occurred: " + throwable.getClass().getName() + (String)msg + " (" + additionalMessage + ")");
    }
}

