/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;

public class ReflectionUtil {
    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static Object newInstance(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new EclibRuntimeException(ex);
        }
    }

    public static <A extends Annotation> Optional<A> searchAnnotationPlacedAtClass(Class<?> classOfTargetInstance, Class<A> annotation) {
        while (classOfTargetInstance != Object.class) {
            A an = classOfTargetInstance.getAnnotation(annotation);
            if (an != null) {
                return Optional.of(an);
            }
            classOfTargetInstance = classOfTargetInstance.getSuperclass();
        }
        return Optional.empty();
    }

    protected static Object getValue(Object object, String propertyPath) {
        try {
            if (propertyPath.contains(".")) {
                String leftMostOfPropertyPath = propertyPath.substring(0, propertyPath.indexOf("."));
                String theRestOfPropertyPath = propertyPath.substring(propertyPath.indexOf(".") + 1);
                return ReflectionUtil.getValue(ReflectionUtil.getValue(object, leftMostOfPropertyPath), theRestOfPropertyPath);
            }
            if (propertyPath.contains("[")) {
                String propertyPathWithoutIndex = propertyPath.substring(0, propertyPath.indexOf("["));
                String tmpSerial = propertyPath.substring(propertyPath.indexOf("[") + 1);
                String index = tmpSerial.substring(0, tmpSerial.indexOf("]"));
                Field rootField = ReflectionUtil.getField(object.getClass(), propertyPathWithoutIndex);
                rootField.setAccessible(true);
                Object objs = rootField.get(object);
                if (objs instanceof Object[]) {
                    return ((Object[])objs)[Integer.parseInt(index)];
                }
                if (objs instanceof List) {
                    return ((List)objs).get(Integer.parseInt(index));
                }
                throw new EclibRuntimeException("Multiple value types other than array and List are not supported. The type of value: " + objs.getClass().getCanonicalName());
            }
            Field rootField = ReflectionUtil.getField(object.getClass(), propertyPath);
            rootField.setAccessible(true);
            return rootField.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            ReflectionUtil.throwRuntimeException(ex, propertyPath, "Field value");
            return null;
        }
    }

    public static Object getLeafBean(Object rootBean, String propertyPath) {
        String leafBeanItemPropertyPath = propertyPath.contains(".") ? propertyPath.substring(0, propertyPath.lastIndexOf(".")) : null;
        return leafBeanItemPropertyPath == null ? rootBean : ReflectionUtil.getValue(rootBean, leafBeanItemPropertyPath);
    }

    @Nonnull
    public static Field getField(Class<?> cls, String propertyPath) {
        Exception ex = null;
        if (propertyPath.contains(".")) {
            String leftMost = propertyPath.substring(0, propertyPath.indexOf("."));
            String theLeft = propertyPath.substring(leftMost.length() + 1);
            return ReflectionUtil.getField(ReflectionUtil.getField(cls, leftMost).getType(), theLeft);
        }
        if (propertyPath.contains("[")) {
            throw new EclibRuntimeException("fieldName with index (like value[0]) not acceptable. fieldName: " + propertyPath);
        }
        while (!cls.equals(Object.class)) {
            try {
                Field validationTargetField = cls.getDeclaredField(propertyPath);
                return validationTargetField;
            }
            catch (Exception exception) {
                if (ex == null) {
                    ex = exception;
                }
                cls = cls.getSuperclass();
            }
        }
        ReflectionUtil.throwRuntimeException(ex, propertyPath, "Field");
        return null;
    }

    private static void throwRuntimeException(Exception ex, String fieldName, String whatIsTriedToObtain) {
        throw new EclibRuntimeException(whatIsTriedToObtain + " cannot be obtained from the field name '" + fieldName + "'", ex);
    }
}

