/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.logging;

import jakarta.annotation.Nullable;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.logging.internal.EclibLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.event.Level;

public class DetailLogger
extends EclibLogger {
    public DetailLogger(@RequireNonnull Object object) {
        this(ObjectsUtil.requireNonNull(object).getClass());
    }

    public DetailLogger(@RequireNonnull Class<?> cls) {
        super(ObjectsUtil.requireNonNull(cls));
    }

    public void trace(@RequireNonnull String message) {
        this.log(Level.TRACE, message);
    }

    public void debug(@RequireNonnull String message) {
        this.log(Level.DEBUG, message);
    }

    public void info(@RequireNonnull String message) {
        this.log(Level.INFO, message);
    }

    public void warn(@RequireNonnull String message) {
        this.log(Level.WARN, message);
    }

    public void warn(@RequireNonnull Throwable th) {
        ObjectsUtil.requireNonNull(th);
        this.log(Level.WARN, th);
    }

    public void error(@RequireNonnull String message) {
        this.log(Level.ERROR, message);
    }

    public void error(@RequireNonnull Throwable throwable) {
        this.error(throwable, "=============== system error occurred ===============");
    }

    public void error(@RequireNonnull Throwable throwable, @Nullable String additionalMessage) {
        this.log(Level.ERROR, throwable, "=============== system error occurred ===============", additionalMessage);
    }

    private void log(@RequireNonnull Level logLevel, @RequireNonnull Throwable throwable) {
        this.log(logLevel, throwable, new String[0]);
    }

    private void log(@RequireNonnull Level logLevel, @RequireNonnull Throwable throwable, String ... additionalMessages) {
        ObjectsUtil.requireNonNull(logLevel, throwable, new Object[0]);
        for (String additionalMessage : additionalMessages) {
            if (StringUtils.isEmpty((CharSequence)additionalMessage)) continue;
            this.log(logLevel, additionalMessage);
        }
        StringBuilder sb = new StringBuilder();
        ExceptionUtil.getMessageAndStackTraceStringRecursively(sb, throwable, null, null);
        this.log(logLevel, sb.toString());
    }
}

