/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util.internal;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class PropertyFileUtilValueGetter {
    private boolean throwsExceptionWhenKeyDoesNotExist;
    private String[][] filePrefixes;
    private static final String[] LIB_MODULES = new String[]{"core", "jpa", "validation"};
    private static final String[] SPLIB_MODULES = new String[]{"core", "web", "web_jpa"};
    private static final String[] UTIL_MODULES = new String[]{"jpa", "poi"};
    private static final String[] APP_MODULES = new String[]{"", "base", "core", "core_web", "core_batch"};
    private static final String[] APP_ENVS = new String[]{"", "profile"};
    private static final List<String> dynamicPostfixList = new ArrayList<String>();
    public static final ThreadLocal<String> bundleNameForModule = new ThreadLocal();
    public static final ThreadLocal<Locale> specifiedLocale = new ThreadLocal();

    public static void addToDynamicPostfixList(String postfix) {
        if (!dynamicPostfixList.contains(postfix)) {
            dynamicPostfixList.add(postfix);
        }
    }

    static List<String> getDynamicPostfixList() {
        return new ArrayList<String>(dynamicPostfixList);
    }

    public PropertyFileUtilValueGetter(@RequireNonnull PropertyFileUtil.PropertyFileUtilFileKindEnum fileKindEnum) {
        this.filePrefixes = ObjectsUtil.requireNonNull(fileKindEnum).getActualFilePrefixes();
        this.throwsExceptionWhenKeyDoesNotExist = fileKindEnum.throwsExceptionWhenKeyDoesNotExist();
    }

    PropertyFileUtilValueGetter(@RequireNonnull String[][] filePrefixes) {
        this.filePrefixes = ObjectsUtil.requireNonNull(filePrefixes);
        this.throwsExceptionWhenKeyDoesNotExist = true;
    }

    List<String> getPostfixes() {
        ArrayList<String> rtnList = new ArrayList<String>();
        rtnList.addAll(Arrays.asList(LIB_MODULES).stream().map(str -> "_lib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(SPLIB_MODULES).stream().map(str -> "_splib_" + str).collect(Collectors.toList()));
        rtnList.addAll(Arrays.asList(UTIL_MODULES).stream().map(str -> "_util_" + str).toList());
        rtnList.addAll(dynamicPostfixList.stream().map(str -> "_" + str).toList());
        for (String moduleName : APP_MODULES) {
            for (String envName : APP_ENVS) {
                rtnList.add((String)(moduleName.equals("") ? "" : "_" + moduleName) + (String)(envName.equals("") ? "" : "-" + envName));
            }
        }
        return rtnList;
    }

    @Nonnull
    private String getValue(@Nullable Locale locale, @RequireNonnull String key, Map<String, Object> elParameterMap) {
        ObjectsUtil.requireNonNull(key);
        String str = this.getRawValue(locale, key);
        return PropertyFileUtil.analyzedValueString(locale, str, elParameterMap);
    }

    private String getRawValue(Locale locale, String key) {
        String value = System.getProperties().keySet().contains(key) ? System.getProperties().getProperty(key) : this.getValueFromPropertiesFiles(locale, key);
        return value;
    }

    private String getValueFromPropertiesFiles(Locale locale, String key) {
        for (String[] filePrefixesOfSamePriority : this.filePrefixes) {
            String value = this.getValueFromPropertiesFilesWithSamePriority(locale, key, filePrefixesOfSamePriority);
            if (value == null) continue;
            return value;
        }
        throw new NoKeyInPropertiesFileException(key);
    }

    private String getValueFromPropertiesFilesWithSamePriority(Locale locale, String key, String[] filePrefixesOfSamePriority) {
        List<String> postfixes = this.getPostfixes();
        HashMap<String, ResourceBundle> rbMap = new HashMap<String, ResourceBundle>();
        for (String prefix : filePrefixesOfSamePriority) {
            for (int i = 0; i < postfixes.size(); ++i) {
                String postfix = postfixes.get(i);
                String filename = prefix + postfix;
                ResourceBundle bundle = this.getResourceBundle(filename, locale);
                rbMap.put(filename, bundle);
            }
        }
        String valueNonDefault = this.getValueAndDuplicationCheck(rbMap, key);
        String valueDefault = this.getValueAndDuplicationCheck(rbMap, key + ".default");
        return valueNonDefault == null ? valueDefault : valueNonDefault;
    }

    @Nonnull
    private ResourceBundle getResourceBundle(@RequireNonnull String bundleId, @Nullable Locale locale) {
        ObjectsUtil.requireNonNull(bundleId);
        if (locale == null) {
            locale = Locale.ROOT;
        }
        try {
            bundleNameForModule.set(bundleId);
            specifiedLocale.set(locale);
            String bundle = "jp.ecuacion.lib.core." + StringUtil.getUpperCamelFromSnake(bundleId.replaceAll("-", "_"));
            return ResourceBundle.getBundle(bundle, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return ResourceBundle.getBundle(bundleId, locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            }
            catch (UnsupportedOperationException | MissingResourceException runtimeException) {
                return null;
            }
        }
    }

    private String getValueAndDuplicationCheck(Map<String, ResourceBundle> resourceBundleMap, String key) {
        String messageString = null;
        for (Map.Entry<String, ResourceBundle> entry : resourceBundleMap.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().containsKey(key)) continue;
            if (messageString != null) {
                throw new KeyDupliccatedException(key);
            }
            messageString = entry.getValue().getString(key);
        }
        return messageString;
    }

    public boolean hasProp(String key) {
        Objects.requireNonNull(key);
        try {
            this.getRawValue(null, key);
            return true;
        }
        catch (NoKeyInPropertiesFileException ex) {
            return false;
        }
    }

    public String getProp(String key, Map<String, Object> elParameterMap) {
        return this.getProp(null, key, elParameterMap);
    }

    @Nonnull
    public String getProp(@Nullable Locale locale, @RequireNonnull String key, Map<String, Object> elParameterMap) {
        ObjectsUtil.requireNonNull(key);
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw new EclibRuntimeException("Message ID is blank.");
        }
        try {
            return this.getValue(locale, key, elParameterMap == null ? new HashMap() : elParameterMap);
        }
        catch (NoKeyInPropertiesFileException ex) {
            if (this.throwsExceptionWhenKeyDoesNotExist) {
                throw ex;
            }
            return key;
        }
    }

    public static class NoKeyInPropertiesFileException
    extends EclibRuntimeException {
        private static final long serialVersionUID = 1L;

        public NoKeyInPropertiesFileException(String key) {
            super("No key in .properties. key: " + key);
        }
    }

    public static class KeyDupliccatedException
    extends EclibRuntimeException {
        private static final long serialVersionUID = 1L;

        public KeyDupliccatedException(String key) {
            super("Duplicated key in .properties. key: " + key);
        }
    }
}

