/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.lib.core.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.el.ELProcessor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.jakartavalidation.bean.ConstraintViolationBean;
import jp.ecuacion.lib.core.util.EmbeddedParameterUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.core.util.internal.PropertyFileUtilValueGetter;
import org.apache.commons.lang3.tuple.Pair;

public class PropertyFileUtil {
    private static Map<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter> getterMap = new HashMap<PropertyFileUtilFileKindEnum, PropertyFileUtilValueGetter>();

    private PropertyFileUtil() {
    }

    @Nonnull
    public static String getApplication(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).getProp(key, null);
    }

    public static boolean hasApplication(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).hasProp(key);
    }

    @Nullable
    public static String getApplicationOrElse(@RequireNonnull String key, String defaultValue) {
        if (getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).hasProp(key)) {
            return getterMap.get((Object)PropertyFileUtilFileKindEnum.APPLICATION).getProp(key, null);
        }
        return defaultValue;
    }

    @Nonnull
    public static String getMessage(@RequireNonnull String key, String ... args) {
        return PropertyFileUtil.getMessage(null, key, args);
    }

    @Nonnull
    public static String getMessage(@Nullable Locale locale, @RequireNonnull String key, String ... args) {
        return PropertyFileUtil.formatMessage(getterMap.get((Object)PropertyFileUtilFileKindEnum.MESSAGES).getProp(locale, key, null), args);
    }

    @Nonnull
    public static String getMessage(@RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMessage(null, key, args);
    }

    @Nonnull
    public static String getMessage(@Nullable Locale locale, @RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMessage(locale, key, PropertyFileUtil.getStringsFromArgs(locale, args));
    }

    public static boolean hasMessage(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.MESSAGES).hasProp(key);
    }

    @Nonnull
    public static String getMessageWithItemName(@RequireNonnull String key, String ... args) {
        return PropertyFileUtil.getMessageWithItemName(null, key, args);
    }

    @Nonnull
    public static String getMessageWithItemName(@Nullable Locale locale, @RequireNonnull String key, String ... args) {
        return PropertyFileUtil.formatMessage(getterMap.get((Object)PropertyFileUtilFileKindEnum.MESSAGES_WITH_ITEM_NAMES).getProp(locale, key, null), args);
    }

    @Nonnull
    public static String getMessageWithItemName(@RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMessageWithItemName(null, key, args);
    }

    @Nonnull
    public static String getMessageWithItemName(@Nullable Locale locale, @RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getMessageWithItemName(locale, key, PropertyFileUtil.getStringsFromArgs(locale, args));
    }

    public static boolean hasMessageWithItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.MESSAGES_WITH_ITEM_NAMES).hasProp(key);
    }

    @Nonnull
    public static String getString(@RequireNonnull String key, String ... args) {
        return PropertyFileUtil.formatMessage(getterMap.get((Object)PropertyFileUtilFileKindEnum.STRINGS).getProp(key, null), args);
    }

    @Nonnull
    public static String getString(@RequireNonnull String key, @RequireNonnull Arg[] args) {
        return PropertyFileUtil.getString(key, PropertyFileUtil.getStringsFromArgs(null, args));
    }

    public static boolean hasString(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.STRINGS).hasProp(key);
    }

    @Nonnull
    public static String getItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAMES).getProp(null, key, null);
    }

    @Nonnull
    public static String getItemName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAMES).getProp(locale, key, null);
    }

    public static boolean hasItemName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ITEM_NAMES).hasProp(key);
    }

    @Nonnull
    public static String getEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAMES).getProp(null, key, null);
    }

    @Nonnull
    public static String getEnumName(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAMES).getProp(locale, key, null);
    }

    public static boolean hasEnumName(@RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.ENUM_NAMES).hasProp(key);
    }

    @Nonnull
    public static String getValidationMessage(@RequireNonnull String key, Map<String, Object> argMap) {
        return PropertyFileUtil.getValidationMessage(null, key, argMap);
    }

    @Nonnull
    public static String getValidationMessage(@Nullable Locale locale, @RequireNonnull String key, @Nullable Map<String, Object> argMap) {
        String message = getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES).getProp(locale, key, argMap);
        return PropertyFileUtil.substituteArgsToValidationMessages(locale, message, argMap);
    }

    @Nonnull
    public static String getValidationMessageWithItemName(@RequireNonnull String key, @Nullable Map<String, Object> argMap) {
        return PropertyFileUtil.getValidationMessageWithItemName(null, key, argMap);
    }

    @Nonnull
    public static String getValidationMessageWithItemName(@Nullable Locale locale, @RequireNonnull String key, @Nullable Map<String, Object> argMap) {
        String message = getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES_WITH_ITEM_NAMES).getProp(locale, key, argMap);
        return PropertyFileUtil.substituteArgsToValidationMessages(locale, message, argMap);
    }

    @Nonnull
    private static String substituteArgsToValidationMessages(@Nullable Locale locale, @RequireNonnull String message, @Nullable Map<String, Object> argMap) {
        argMap = argMap == null ? new HashMap<String, String>() : argMap;
        String argAnnotationValue = (String)argMap.get("annotation");
        ConstraintViolationBean.FieldInfoBean[] fieldInfoBean = (ConstraintViolationBean.FieldInfoBean[])argMap.get("itemAttributes");
        String annotationPrefix = "jp.ecuacion.lib.core.jakartavalidation.validator.Conditional";
        if (argAnnotationValue != null && argAnnotationValue.startsWith(annotationPrefix)) {
            List<String> itemNameList = Arrays.asList(fieldInfoBean).stream().map(bean -> PropertyFileUtil.getItemName(locale, bean.itemNameKey)).toList();
            argMap.put("itemName", StringUtil.getCsvWithSpace(itemNameList));
        }
        String rtnMessage = message;
        for (Map.Entry entry : argMap.entrySet()) {
            rtnMessage = rtnMessage.replace("{" + (String)entry.getKey() + "}", entry.getValue() == null ? "''" : entry.getValue().toString().replace("{", "'{'").replace("}", "'}'"));
        }
        return rtnMessage;
    }

    @Nonnull
    public static String getValidationMessagePatternDescription(@RequireNonnull String key) {
        return PropertyFileUtil.getValidationMessagePatternDescription(null, key);
    }

    @Nonnull
    public static String getValidationMessagePatternDescription(@Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.VALIDATION_MESSAGES_PATTERN_DESCRIPTIONS).getProp(locale, key, null);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.valueOf(propertyUtilFileKind.toUpperCase())).getProp(null, key, null);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @Nullable Locale locale, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.valueOf(propertyUtilFileKind.toUpperCase())).getProp(locale, key, null);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @Nullable Locale locale, @RequireNonnull String key, String ... args) {
        return PropertyFileUtil.formatMessage(PropertyFileUtil.get(propertyUtilFileKind, locale, key), args);
    }

    @Nonnull
    public static String get(@RequireNonnull String propertyUtilFileKind, @Nullable Locale locale, @RequireNonnull String key, Arg ... args) {
        return PropertyFileUtil.get(propertyUtilFileKind, locale, key, PropertyFileUtil.getStringsFromArgs(locale, args));
    }

    public static boolean has(@RequireNonnull String propertyUtilFileKind, @RequireNonnull String key) {
        return getterMap.get((Object)PropertyFileUtilFileKindEnum.valueOf(propertyUtilFileKind.toUpperCase())).hasProp(key);
    }

    public static void addResourceBundlePostfix(@RequireNonnull String postfix) {
        PropertyFileUtilValueGetter.addToDynamicPostfixList(postfix);
    }

    private static String formatMessage(String msgStr, String ... args) {
        return args.length == 0 ? msgStr : MessageFormat.format(msgStr, args);
    }

    @Nonnull
    public static String getStringFromArg(@Nullable Locale locale, @RequireNonnull Arg arg) {
        String str = null;
        String msgIdStr = "";
        if (arg.argKind == ArgKind.MESSAGE_ID) {
            for (String fileKind : arg.getFileKinds()) {
                if (!PropertyFileUtil.has(fileKind, arg.getArgString())) continue;
                msgIdStr = PropertyFileUtil.get(fileKind, locale, arg.getArgString(), arg.messageArgs);
            }
        }
        switch (arg.argKind.ordinal()) {
            case 2: {
                str = msgIdStr;
                break;
            }
            case 1: {
                str = PropertyFileUtil.analyzedValueString(locale, arg.getArgString(), null);
                break;
            }
            case 0: {
                str = arg.getArgString();
                break;
            }
            default: {
                throw new EclibRuntimeException("Unexpected.");
            }
        }
        return str;
    }

    private static String[] getStringsFromArgs(Locale locale, @RequireNonnull Arg[] args) {
        ArrayList list = new ArrayList();
        Arrays.asList(ObjectsUtil.requireNonNull(args)).stream().forEach(arg -> list.add(PropertyFileUtil.getStringFromArg(locale, arg)));
        return list.toArray(new String[list.size()]);
    }

    public static String analyzedValueString(@Nullable Locale locale, String rawString, Map<String, Object> elParameterMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(rawString);
        List<Pair<String, String>> list = null;
        elParameterMap = elParameterMap == null ? new HashMap<String, Object>() : elParameterMap;
        Locale locale2 = locale = locale == null ? Locale.ENGLISH : locale;
        if (sb.toString().contains("${+")) {
            list = PropertyFileUtil.analyze(sb.toString());
            sb = new StringBuilder();
            for (Pair<String, String> tuple : list) {
                if (tuple.getLeft() == null) {
                    sb.append((String)tuple.getRight());
                    continue;
                }
                sb.append(PropertyFileUtil.get((String)tuple.getLeft(), locale, (String)tuple.getRight()));
            }
        }
        if (sb.toString().contains("${")) {
            try {
                list = EmbeddedParameterUtil.getPartList(sb.toString(), new String[]{"${"}, "}", new EmbeddedParameterUtil.Options().setIgnoresEmergenceOfEndSymbolOnly(true));
            }
            catch (MultipleAppException | EmbeddedParameterUtil.StringFormatIncorrectException ex) {
                throw new EclibRuntimeException(ex);
            }
            sb = new StringBuilder();
            ELProcessor elProcessor = new ELProcessor();
            elParameterMap.forEach((arg_0, arg_1) -> ((ELProcessor)elProcessor).setValue(arg_0, arg_1));
            for (Pair<String, String> tuple : list) {
                if (tuple.getLeft() == null) {
                    sb.append((String)tuple.getRight());
                    continue;
                }
                sb.append(elProcessor.eval((String)tuple.getRight()).toString());
            }
        }
        return sb.toString();
    }

    private static List<Pair<String, String>> analyze(String string) {
        String prefix = "${+";
        List<String> startSymbols = Arrays.asList(PropertyFileUtilFileKindEnum.values()).stream().map(en -> prefix + en.toString().toLowerCase() + ":").toList();
        try {
            List<Pair<String, String>> list = EmbeddedParameterUtil.getPartList(string, startSymbols.toArray(new String[startSymbols.size()]), "}", new EmbeddedParameterUtil.Options().setIgnoresEmergenceOfEndSymbolOnly(true));
            return list.stream().map(pair -> pair.getLeft() == null ? pair : Pair.of((Object)((String)pair.getLeft()).substring(prefix.length(), ((String)pair.getLeft()).length() - 1), (Object)((String)pair.getRight()))).toList();
        }
        catch (AppException ex) {
            throw new EclibRuntimeException(ex);
        }
    }

    static {
        for (PropertyFileUtilFileKindEnum anEnum : PropertyFileUtilFileKindEnum.values()) {
            getterMap.put(anEnum, new PropertyFileUtilValueGetter(anEnum));
        }
    }

    public static enum PropertyFileUtilFileKindEnum {
        APPLICATION(new String[][]{{"application"}}, true),
        MESSAGES(new String[][]{{"messages"}}, false),
        MESSAGES_WITH_ITEM_NAMES(new String[][]{{"messages_with_item_names"}, {"messages"}}, false),
        STRINGS(new String[][]{{"strings"}}, false),
        ITEM_NAMES(new String[][]{{"item_names"}, {"messages"}}, false),
        ENUM_NAMES(new String[][]{{"enum_names"}}, false),
        VALIDATION_MESSAGES(new String[][]{{"ValidationMessages"}}, false),
        VALIDATION_MESSAGES_WITH_ITEM_NAMES(new String[][]{{"ValidationMessagesWithItemNames"}}, false),
        VALIDATION_MESSAGES_PATTERN_DESCRIPTIONS(new String[][]{{"ValidationMessagesPatternDescriptions"}, {"ValidationMessages"}}, false);

        private String[][] actualFilePrefixes;
        private boolean throwsExceptionWhenKeyDoesNotExist;

        private PropertyFileUtilFileKindEnum(String[][] actualFilePrefixes, boolean throwsExceptionWhenKeyDoesNotExist) {
            this.actualFilePrefixes = actualFilePrefixes;
            this.throwsExceptionWhenKeyDoesNotExist = throwsExceptionWhenKeyDoesNotExist;
        }

        public String[][] getActualFilePrefixes() {
            return this.actualFilePrefixes;
        }

        public boolean throwsExceptionWhenKeyDoesNotExist() {
            return this.throwsExceptionWhenKeyDoesNotExist;
        }
    }

    public static class Arg {
        private ArgKind argKind;
        private String[] fileKinds;
        private String argString;
        private Arg[] messageArgs;

        private Arg(ArgKind argKind, String argString, Arg ... messageArgs) {
            this.argKind = argKind;
            this.fileKinds = new String[0];
            this.argString = argString;
            this.messageArgs = messageArgs;
        }

        private Arg(String[] fileKinds, String argString, Arg ... messageArgs) {
            this.argKind = ArgKind.MESSAGE_ID;
            this.fileKinds = fileKinds;
            this.argString = argString;
            this.messageArgs = messageArgs;
        }

        public static Arg string(String argString) {
            return new Arg(ArgKind.STRING, argString, new Arg[0]);
        }

        public static Arg[] strings(String ... argStrings) {
            return Arrays.asList(argStrings).stream().map(arg -> Arg.string(arg)).toList().toArray(new Arg[argStrings.length]);
        }

        public static Arg formattedString(String formattedString) {
            return new Arg(ArgKind.FORMATTED_STRING, formattedString, new Arg[0]);
        }

        public static Arg message(String messageId) {
            return new Arg(new String[]{PropertyFileUtilFileKindEnum.MESSAGES.toString()}, messageId, new Arg[0]);
        }

        public static Arg message(String messageId, String ... stringArgs) {
            List<String> stringArgList = Arrays.asList(stringArgs);
            Arg[] args = stringArgList.stream().map(str -> Arg.string(str)).toList().toArray(new Arg[stringArgList.size()]);
            return new Arg(new String[]{PropertyFileUtilFileKindEnum.MESSAGES.toString()}, messageId, args);
        }

        public static Arg message(String messageId, Arg ... messageArgs) {
            return new Arg(new String[]{PropertyFileUtilFileKindEnum.MESSAGES.toString()}, messageId, messageArgs);
        }

        public static Arg get(String[] fileKinds, String messageId) {
            return new Arg(fileKinds, messageId, new Arg[0]);
        }

        public static Arg get(String[] fileKinds, String messageId, String ... stringArgs) {
            List<String> stringArgList = Arrays.asList(stringArgs);
            Arg[] args = stringArgList.stream().map(str -> Arg.string(str)).toList().toArray(new Arg[stringArgList.size()]);
            return new Arg(fileKinds, messageId, args);
        }

        public static Arg get(String[] fileKinds, String messageId, Arg ... messageArgs) {
            return new Arg(fileKinds, messageId, messageArgs);
        }

        public ArgKind getArgKind() {
            return this.argKind;
        }

        public String[] getFileKinds() {
            return this.fileKinds;
        }

        public String getArgString() {
            return this.argString;
        }

        public Arg[] getMessageArgs() {
            return this.messageArgs;
        }
    }

    public static enum ArgKind {
        STRING,
        FORMATTED_STRING,
        MESSAGE_ID;

    }
}

